function dguiwvdi(varargin)
%DGUIWVDI Demonstrates wavelet display GUI tools in the Wavelet Toolbox. 

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-Mar-96.
%   Last Revision: 09-Jul-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
% $Revision: 1.10 $

% Check arguments.
%=================
switch nargin
  case 0 , figNumber = 0; wait_mode = 1;
  case 2 ,   
    if isequal(varargin{1},'noGUI')
        figNumber = 0;
        wait_mode = varargin{2};
    else
        figNumber = varargin{1};
        wait_mode = 1;
    end
end

if wshowdrv('init',figNumber)
    if figNumber==0  
        active_fig = wvdtool;
	wenamngr('Inactive',active_fig);
    else
        active_fig = demoguim('startshow',figNumber,'wvdtool');
	wenamngr('Inactive',active_fig);
        wshowdrv('setactfig',figNumber,active_fig);
        return;
    end
end
if figNumber , active_fig = wshowdrv('getactfig',figNumber); end

wvdtool('demo',active_fig,'db4');
wenamngr('Inactive',active_fig);
if wshowdrv('pause',figNumber,wait_mode), return; end;

wvdtool('demo',active_fig,'bior4.4');
wenamngr('Inactive',active_fig);
if wshowdrv('pause',figNumber,wait_mode), return; end;

wvdtool('demo',active_fig,'meyr');
wenamngr('Inactive',active_fig);
if wshowdrv('pause',figNumber,wait_mode), return; end;

wvdtool('demo',active_fig,'mexh');
wenamngr('Inactive',active_fig);
if wshowdrv('pause',figNumber,wait_mode), return; end;

wvdtool('demo',active_fig,'cmor1-1');
wenamngr('Inactive',active_fig);

if figNumber==0
    wshowdrv('pause',figNumber,wait_mode);
    wvdtool('close',active_fig);
    delete(active_fig)
end
