function dguiwp2d(varargin)
%DGUIWP2D Demonstrates 2-D wavelet packet GUI tools in the Wavelet Toolbox.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-Mar-96.
%   Last Revision: 27-Jun-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
% $Revision: 1.11 $

% Check arguments.
%=================
switch nargin
  case 0 , figNumber = 0; wait_mode = 1;
  case 2 ,   
    if isequal(varargin{1},'noGUI')
        figNumber = 0;
        wait_mode = varargin{2};
    else
        figNumber = varargin{1};
        wait_mode = 1;
    end
end

if wshowdrv('init',figNumber)
    if figNumber==0  
        active_fig = wp2dtool;
        wenamngr('Inactive',active_fig);
    else
        active_fig = demoguim('startshow',figNumber,'wp2dtool');
        wenamngr('Inactive',active_fig);
        wshowdrv('setactfig',figNumber,active_fig);
        tag_sli_size = 'Sli_Size';
        tag_sli_pos  = 'Sli_Pos';
        sli_handles  = findobj(active_fig,'style','slider');
        sli_size     = findobj(sli_handles,'Tag',tag_sli_size);
        sli_pos      = findobj(sli_handles,'Tag',tag_sli_pos);
        set([sli_size;sli_pos],'visible','off');
        return;
    end
end
if figNumber , active_fig = wshowdrv('getactfig',figNumber); end

wp2dmngr('demo',active_fig,'noiswom','sym4',2,'shannon');
wenamngr('Inactive',active_fig);
if wshowdrv('pause',figNumber,wait_mode), return; end;

tag_nodlab   = 'Pop_NodLab';
tag_nodact   = 'Pop_NodAct';
tag_nodsel   = 'Pus_NodSel';
tag_pus_full = str2mat(...
                      'Pus_Full.1','Pus_Full.2',...
                      'Pus_Full.3','Pus_Full.4'...
                       );
tag_axe_t_lin = 'Axe_TreeLines';
tag_txt_in_t  = 'Txt_In_tree';

pop_handles  = findobj(active_fig,'style','popupmenu');
pus_handles  = findobj(active_fig,'style','pushbutton');
pop_nodlab   = findobj(pop_handles,'Tag',tag_nodlab);
pop_nodact   = findobj(pop_handles,'Tag',tag_nodact);
pus_full     = findobj(pus_handles,'tag',tag_pus_full(2,:));
pus_nodsel   = findobj(pus_handles,'Tag',tag_nodsel);
cba_nodlab   = get(pop_nodlab,'Callback');
cba_nodact   = get(pop_nodact,'Callback');
cba_nodsel   = get(pus_nodsel,'Callback');
cba_full     = get(pus_full,'Callback');
axe_handles  = findobj(active_fig,'type','axes');
WP_Axe_Tree  = findobj(axe_handles,'flat','Tag',tag_axe_t_lin);

msg = str2mat(...
        ['To change the Node Label use the corresponding popupmenu ' ...
       'in the middle of the window.'], ...
        'The default labelling is the depth-position labelling', ...
        'We select the indices labelling.'  ...
        );
if dguiwait('pause',figNumber,0,active_fig,msg); return; end

set(pop_nodlab,'value',2);
eval(cba_nodlab);
if wshowdrv('pause',figNumber,wait_mode), return; end;

msg = str2mat(...
        ['To change the Node Action use the corresponding popupmenu ' ...
       'in the middle of the window.'], ...
        'The default Node Action is Visualize.', ...
        'We select the Select On node action.'  ...
        );
if dguiwait('pause',figNumber,wait_mode,active_fig,msg); return; end

set(pop_nodact,'value',4);

msg = 'Now we select the nodes [2 3 5].';
if dguiwait('pause',figNumber,0,active_fig,msg); return; end

eval(cba_nodact);
Tree_txt = findobj(WP_Axe_Tree,'type','text','tag',tag_txt_in_t);
for num = [5 2 3]
        hdl_node = findobj(Tree_txt,'userdata',num);
        cba_node = get(hdl_node,'ButtonDownFcn');
        set(active_fig,'CurrentObject',hdl_node);
        eval(cba_node);
end

msg = 'We use the "Reconstruct" pushbutton.';
if dguiwait('pause',figNumber,0,active_fig,msg); return; end

eval(cba_nodsel)
if wshowdrv('pause',figNumber,wait_mode), return; end;

msg = str2mat(...
         'The four pushbuttons labelled [1 2 3 4] in the middle of the window', ...
         'allow to see Full Size for one of the four axes.', ...
         'Let''s display the reconstructed packets (button 2) Full Size.' ...
        );
if dguiwait('pause',figNumber,0,active_fig,msg); return; end

eval(cba_full);
if wshowdrv('pause',figNumber,wait_mode), return; end;

eval(cba_full);
if wshowdrv('pause',figNumber,wait_mode), return; end;

msg = 'We change the node action and unselect the nodes [2 3 5].';
if dguiwait('pause',figNumber,0,active_fig,msg); return; end

set(pop_nodact,'value',5);
eval(cba_nodact);
if wshowdrv('pause',figNumber,wait_mode), return; end;

msg = 'The Compress pushbutton is used to call the compression tool.';
if dguiwait('pause',figNumber,0,active_fig,msg); return; end

out2 = wp2dmngr('comp',active_fig);
wenamngr('Inactive',out2);

msg = 'We compress the image with the default options.';
if dguiwait('pause',figNumber,0,out2,msg); return; end

wp2dcomp('compress',out2,active_fig);
if wshowdrv('pause',figNumber,wait_mode), return; end;

delete(out2); drawnow; pause(2)
wp2dmngr('return_comp',active_fig,0);
wenamngr('Inactive',active_fig);

msg = 'The De-noise pushbutton is used to call the de-noising tool.';
if dguiwait('pause',figNumber,0,active_fig,msg); return; end

out3 = wp2dmngr('deno',active_fig);
wenamngr('Inactive',out3);

msg = 'We de-noise the image with the default options.';
if dguiwait('pause',figNumber,0,out3,msg); return; end

wp2ddeno('denoise',out3,active_fig);
if wshowdrv('pause',figNumber,wait_mode), return; end;

delete(out3); drawnow; pause(2)
wp2dmngr('return_deno',active_fig,0);
wenamngr('Inactive',active_fig);

msg = 'The Statistics information for the node 0 are displayed clicking on the node.';
if dguiwait('pause',figNumber,0,active_fig,msg); return; end

set(pop_nodact,'value',6);
eval(cba_nodact);
out4 = wp2dstat('create',active_fig,0);
wp2dstat('demo',out4);
wenamngr('Inactive',out4);
if wshowdrv('pause',figNumber,wait_mode), return; end;

delete(out4); drawnow; pause(2)
if figNumber==0
    wshowdrv('pause',figNumber,wait_mode);
    wp2dtool('close',active_fig);
    delete(active_fig)
end
