function dguiwp1d(varargin)
%DGUIWP1D Demonstrates 1-D wavelet packet GUI tools in the Wavelet Toolbox.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-Mar-96.
%   Last Revision: 27-Jun-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
% $Revision: 1.11 $

% Check arguments.
%=================
switch nargin
  case 0 , figNumber = 0; wait_mode = 1;
  case 2 ,   
    if isequal(varargin{1},'noGUI')
        figNumber = 0;
        wait_mode = varargin{2};
    else
        figNumber = varargin{1};
        wait_mode = 1;
    end
end

if wshowdrv('init',figNumber)
    if figNumber==0 
        active_fig = wp1dtool;
        wenamngr('Inactive',active_fig);
    else
        active_fig = demoguim('startshow',figNumber,'wp1dtool');
        wenamngr('Inactive',active_fig);
        wshowdrv('setactfig',figNumber,active_fig);
        tag_sli_size = 'Sli_Size';
        tag_sli_pos  = 'Sli_Pos';
        sli_handles  = findobj(active_fig,'style','slider');
        sli_size     = findobj(sli_handles,'Tag',tag_sli_size);
        sli_pos      = findobj(sli_handles,'Tag',tag_sli_pos);
        set([sli_size;sli_pos],'visible','off');
        return;
    end
end
if figNumber , active_fig = wshowdrv('getactfig',figNumber); end

wp1dmngr('demo',active_fig,'noischir','db3',4,'threshold',0.2);
wenamngr('Inactive',active_fig);
if wshowdrv('pause',figNumber,wait_mode), return; end;

tag_pus_btree   = 'Pus_Btree';
tag_inittree    = 'Pus_InitTree';
tag_wavtree     = 'Pus_WavTree';
tag_nodlab      = 'Pop_NodLab';
tag_nodact      = 'Pop_NodAct';
tag_pus_full    = str2mat(...
                       'Pus_Full.1','Pus_Full.2',...
                       'Pus_Full.3','Pus_Full.4'...
                        );
tag_pop_colm    = 'Txt_PopM';
tag_axe_t_lin   = 'Axe_TreeLines';
tag_txt_in_t    = 'Txt_In_tree';

pop_handles     = findobj(active_fig,'style','popupmenu');
pus_handles     = findobj(active_fig,'style','pushbutton');
pus_inittree    = findobj(pus_handles,'Tag',tag_inittree);
pus_wavtree     = findobj(pus_handles,'Tag',tag_wavtree);
pus_btree       = findobj(pus_handles,'Tag',tag_pus_btree);
pus_full        = findobj(pus_handles,'tag',tag_pus_full(4,:));
pop_nodlab      = findobj(pop_handles,'Tag',tag_nodlab);
pop_nodact      = findobj(pop_handles,'Tag',tag_nodact);
pop_colm        = findobj(pop_handles,'Tag',tag_pop_colm);
cba_inittree    = get(pus_inittree,'Callback');
cba_wavtree     = get(pus_wavtree,'Callback');
cba_btree       = get(pus_btree,'Callback');
cba_full        = get(pus_full,'Callback');
cba_colm        = get(pop_colm,'Callback');
cba_nodlab      = get(pop_nodlab,'Callback');
cba_nodact      = get(pop_nodact,'Callback');
axe_handles     = findobj(active_fig,'type','axes');
WP_Axe_Tree	= findobj(axe_handles,'flat','Tag',tag_axe_t_lin);

msg = str2mat(...
        ['To change the Node Label use the corresponding popupmenu ' ...
       'in the middle of the window.'], ...
        'The default labelling is the depth-position labelling', ...
        'We select the indices labelling.'  ...
        );
if dguiwait('pause',figNumber,0,active_fig,msg); return; end

set(pop_nodlab,'value',2);
eval(cba_nodlab);
if wshowdrv('pause',figNumber,wait_mode), return; end;

msg = str2mat('We select the entropy labelling which gives the entropy of each packet');
if dguiwait('pause',figNumber,0,active_fig,msg); return; end

set(pop_nodlab,'value',3);
eval(cba_nodlab);
if wshowdrv('pause',figNumber,wait_mode), return; end;

msg = str2mat('We select the length labelling which gives the length of each packet');
if dguiwait('pause',figNumber,0,active_fig,msg); return; end

set(pop_nodlab,'value',5);
eval(cba_nodlab);
if wshowdrv('pause',figNumber,wait_mode), return; end;

msg = str2mat('We go back to the depth-position labelling.');
if dguiwait('pause',figNumber,0,active_fig,msg); return; end

set(pop_nodlab,'value',1);
eval(cba_nodlab);
if wshowdrv('pause',figNumber,wait_mode), return; end;

msg = ['We extract the Wavelet tree using the corresponding pushbutton ' ...
       'in the middle of the window.'];
if dguiwait('pause',figNumber,0,active_fig,msg); return; end

eval(cba_wavtree);
if wshowdrv('pause',figNumber,wait_mode), return; end;

msg = ['We restore the Initial tree using the corresponding pushbutton ' ...
       'in the middle of the window.'];
if dguiwait('pause',figNumber,0,active_fig,msg); return; end

eval(cba_inittree);
if wshowdrv('pause',figNumber,wait_mode), return; end;

msg = ['We Compute the Best tree using the corresponding pushbutton ' ...
       'in the middle of the window.'];
if dguiwait('pause',figNumber,0,active_fig,msg); return; end

eval(cba_btree);
if wshowdrv('pause',figNumber,wait_mode), return; end;

eval(cba_inittree);
if wshowdrv('pause',figNumber,wait_mode), return; end;

msg = str2mat(...
         'The four pushbuttons labelled [1 2 3 4] in the middle of the window', ...
         'allow to see Full Size for one of the four axes.', ...
         'Let''s display the coefficients (button 4) Full Size.' ...
        );
if dguiwait('pause',figNumber,0,active_fig,msg); return; end

eval(cba_full);
if wshowdrv('pause',figNumber,wait_mode), return; end;

msg = 'We restore the previous display.';
if dguiwait('pause',figNumber,0,active_fig,msg); return; end

eval(cba_full);
if wshowdrv('pause',figNumber,wait_mode), return; end;

msg = str2mat(...
        ['To change the Coloration Mode use the popupmenu at the bottom ' ...
        'of the window.'], ...
        'Eight coloration modes are available.', ...
        'Four are based on the frequency order of the packets,', ...
        'The other four are based on the natural order of the packets.', ...
        'We select the natural order : by level and with abs. value of coefficients.' ...
        );
if dguiwait('pause',figNumber,0,active_fig,msg); return; end

set(pop_colm,'value',5);
eval(cba_colm);
if wshowdrv('pause',figNumber,wait_mode), return; end;

msg = 'We restore the frequency order : global with abs. value of coefficients.';
if dguiwait('pause',figNumber,0,active_fig,msg); return; end

set(pop_colm,'value',1);
eval(cba_colm);
if wshowdrv('pause',figNumber,wait_mode), return; end;

msg = 'We change Node Action to Split-Merge and we merge the node (1,1) or 2.';
if dguiwait('pause',figNumber,0,active_fig,msg); return; end

set(pop_nodact,'value',2);
eval(cba_nodact);
Tree_txt = findobj(WP_Axe_Tree,'type','text','tag',tag_txt_in_t);
hdl_node = findobj(Tree_txt,'userdata',2);
cba_node = get(hdl_node,'ButtonDownFcn');
set(active_fig,'CurrentObject',hdl_node);
eval(cba_node);
if wshowdrv('pause',figNumber,wait_mode), return; end;

msg = ['We restore the Initial tree using the corresponding pushbutton ' ...
       'in the middle of the window.'];
if dguiwait('pause',figNumber,0,active_fig,msg); return; end

eval(cba_inittree);
if wshowdrv('pause',figNumber,wait_mode), return; end;

msg = 'The Compress pushbutton is used to call the compression tool.';
if dguiwait('pause',figNumber,0,active_fig,msg); return; end

out2 = wp1dmngr('comp',active_fig);
wenamngr('Inactive',out2);

msg = 'We compress the signal with the default options.';
if dguiwait('pause',figNumber,0,out2,msg); return; end

wp1dcomp('compress',out2,active_fig);
if wshowdrv('pause',figNumber,wait_mode), return; end;
delete(out2); drawnow; pause(2)
wp1dmngr('return_comp',active_fig,0);
wenamngr('Inactive',active_fig);

msg = 'The De-noise pushbutton is used to call the de-noising tool.';
if dguiwait('pause',figNumber,0,active_fig,msg); return; end

out3 = wp1dmngr('deno',active_fig);
wenamngr('Inactive',out3);

msg = 'We de-noise the signal with the default options.';
if dguiwait('pause',figNumber,0,out3,msg); return; end

wp1ddeno('denoise',out3,active_fig);
if wshowdrv('pause',figNumber,wait_mode), return; end;
delete(out3); drawnow; pause(2)
wp1dmngr('return_deno',active_fig,0);
wenamngr('Inactive',active_fig);

msg = 'The Statistics information for the node 1 are displayed clicking on the node.';
if dguiwait('pause',figNumber,0,active_fig,msg); return; end

set(pop_nodlab,'value',2);
eval(cba_nodlab);
set(pop_nodact,'value',6);
eval(cba_nodact);
out4 = wp1dstat('create',active_fig,1);
wp1dstat('demo',out4);
wenamngr('Inactive',out4);
if wshowdrv('pause',figNumber,wait_mode), return; end;

delete(out4); drawnow; pause(2)
if figNumber==0
    wshowdrv('pause',figNumber,wait_mode);
    wp1dtool('close',active_fig);
    delete(active_fig)
end
