function dguisw2d(varargin)
%DGUISW2D Demonstrates 2-D SWT de-noising wavelet GUI tools in the Wavelet Toolbox.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 05-May-99.
%   Last Revision: 05-Jul-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.5 $  $Date: 2001/03/30 16:34:55 $

% Check arguments.
%=================
switch nargin
  case 0 , figNumber = 0; wait_mode = 1;
  case 2 ,   
    if isequal(varargin{1},'noGUI')
        figNumber = 0;
        wait_mode = varargin{2};
    else
        figNumber = varargin{1};
        wait_mode = 1;
    end
end

if wshowdrv('init',figNumber)
    if figNumber==0
        active_fig = sw2dtool;
        wenamngr('Inactive',active_fig);
    else
        active_fig = demoguim('startshow',figNumber,'sw2dtool');
        wenamngr('Inactive',active_fig);
        wshowdrv('setactfig',figNumber,active_fig);
        return;
    end
end
if exist('wait_mode')~=1 , wait_mode = 1; end
if figNumber , active_fig = wshowdrv('getactfig',figNumber); end

demoSET = {...
  'noiswom'  , 'haar', 3 , {'penallo',46.12} ; ...
  'noiswom'  , 'haar', 5 , {'penallo',48.62} ; ...
  'noiswom'  , 'db3' , 4 , {'penallo',NaN}   ; ...
  'nbarb1'   , 'db1' , 4 , {} ; ...
  'noissi2d' , 'db1' , 2 , {}   ...
  };

nbDEM = size(demoSET,1);
for k = 1:nbDEM
    paramDEM = demoSET(k,:);
    sw2dtool('demo',active_fig,paramDEM{:});
    wenamngr('Inactive',active_fig);
    if k<nbDEM
      if wshowdrv('pause',figNumber,wait_mode), return; end;
    end
end

% sw2dtool('demo',active_fig,'noiswom','haar',3);
% wenamngr('Inactive',active_fig);
% if wshowdrv('pause',figNumber,wait_mode), return; end;


if figNumber==0
    wshowdrv('pause',figNumber,wait_mode);
    sw2dtool('close',active_fig);
    delete(active_fig)
end
