function dguisw1d(varargin)
%DGUISW1D Demonstrates 1-D SWT de-noising wavelet GUI tools in the Wavelet Toolbox.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 05-May-99.
%   Last Revision: 16-Jul-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.5 $  $Date: 2001/03/30 16:34:54 $

% Check arguments.
%=================
switch nargin
  case 0 , figNumber = 0; wait_mode = 1;
  case 2 ,   
    if isequal(varargin{1},'noGUI')
        figNumber = 0;
        wait_mode = varargin{2};
    else
        figNumber = varargin{1};
        wait_mode = 1;
    end
end

if wshowdrv('init',figNumber)
    if figNumber==0
        active_fig = sw1dtool;
        wenamngr('Inactive',active_fig);
    else
        active_fig = demoguim('startshow',figNumber,'sw1dtool');
        wenamngr('Inactive',active_fig);
        wshowdrv('setactfig',figNumber,active_fig);
        return;
    end
end
if exist('wait_mode')~=1 , wait_mode = 1; end
if figNumber , active_fig = wshowdrv('getactfig',figNumber); end

demoSET = {...
  'noisbloc' , 'haar', 5 , {} ; ...
  'noisbump' , 'sym4', 5 , {} ; ...
  'heavysin' , 'sym8', 5 , {} ; ...
  'noisdopp' , 'sym4', 5 , {} ; ...
  'noischir' , 'db1' , 5 , {} ; ...
  'noismima' , 'db3' , 6 , {} ; ...
  'noisbloc' , 'haar', 5 , {'penallo'}; ...
  'nblocr1'  , 'haar', 5 , {3} ; ...
  'nblocr2'  , 'haar', 5 , {3} ; ...
  'ndoppr1'  , 'haar', 5 , {3} ; ...
  'nbumpr1'  , 'haar', 5 , {3} ; ...
  'nbumpr2'  , 'haar', 5 , {2} ; ...
  'nbumpr3'  , 'haar', 5 , {4} ; ...
  'nelec'    , 'haar', 4 , {3}   ...
  };
nbDEM = size(demoSET,1);
for k = 1:nbDEM
    paramDEM = demoSET(k,:);
    sw1dtool('demo',active_fig,paramDEM{:});
    wenamngr('Inactive',active_fig);
    if k<nbDEM
      if wshowdrv('pause',figNumber,wait_mode), return; end;
    end
end

% sw1dtool('demo',active_fig,'noisbloc','haar',5);
% wenamngr('Inactive',active_fig);
% if wshowdrv('pause',figNumber,wait_mode), return; end;

if figNumber==0
    wshowdrv('pause',figNumber,wait_mode);
    sw1dtool('close',active_fig);
    delete(active_fig)
end
