function dguiiext(varargin)
%DGUISEXT Demonstrates Signal extension GUI tools in the Wavelet Toolbox.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 03-Jul-99.
%   Last Revision: 09-Dec-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.5 $  $Date: 2001/03/30 16:34:54 $

% Check arguments.
%=================
switch nargin
  case 0 , figNumber = 0; wait_mode = 1;
  case 2 ,   
    if isequal(varargin{1},'noGUI')
        figNumber = 0;
        wait_mode = varargin{2};
    else
        figNumber = varargin{1};
        wait_mode = 1;
    end
end

if wshowdrv('init',figNumber)
    if figNumber==0 
        active_fig = sigxtool;
	wenamngr('Inactive',active_fig);
    else
        active_fig = demoguim('startshow',figNumber,'sigxtool');
	wenamngr('Inactive',active_fig);
        wshowdrv('setactfig',figNumber,active_fig);
        return;
    end
end
if figNumber , active_fig = wshowdrv('getactfig',figNumber); end

demoSET = {...
  'noisbloc' , 'ext'   , {'zpd' , 1236 , 'both'}  ; ...
  'noisbloc' , 'trunc' , {'nul' ,  865 , 'both'}  ; ...
  'cuspamax' , 'ext'   , {'spd' , 1400 , 'right'} ; ...
  'cuspamax' , 'ext'   , {'spd' , 1400 , 'left'}  ; ...
  'cuspamax' , 'ext'   , {'spd' , 1400 , 'both'}  ; ...
  'noisbump' , 'ext'   , {'sym' , 1600 , 'both'}  ; ...
  'freqbrk'  , 'trunc' , {'nul' ,  666 , 'left'}  ; ...
  'freqbrk'  , 'ext'   , {'swt' ,   10 , 'right'}    ...
  };
nbDEM = size(demoSET,1);

for k = 1:nbDEM
    paramDEM = demoSET(k,:);
    sigxtool('demo',active_fig,paramDEM{:});
    wfigmngr('storeValue',active_fig,'File_Save_Flag',1);
    wenamngr('Inactive',active_fig);
    if k<nbDEM
      if wshowdrv('pause',figNumber,wait_mode), return; end;
    end
end

if figNumber==0
    wshowdrv('pause',figNumber,wait_mode);
    sigxtool('close',active_fig);
    delete(active_fig)
end
