function dguire1d(varargin)
%DGUIRE1D Demonstrates 1-D Regression estimation GUI tools in the Wavelet Toolbox.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 03-Jul-99.
%   Last Revision: 16-Jul-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.5 $  $Date: 2001/03/30 16:34:53 $

% Check arguments.
%=================
switch nargin
  case 0 , figNumber = 0; wait_mode = 1;
  case 2 ,   
    if isequal(varargin{1},'noGUI')
        figNumber = 0;
        wait_mode = varargin{2};
    else
        figNumber = varargin{1};
        wait_mode = 1;
    end
end

if wshowdrv('init',figNumber)
    if figNumber==0 
        active_fig = re1dtool;
	wenamngr('Inactive',active_fig);
    else
        active_fig = demoguim('startshow',figNumber,'re1dtool');
	wenamngr('Inactive',active_fig);
        wshowdrv('setactfig',figNumber,active_fig);
        return;
    end
end
if figNumber , active_fig = wshowdrv('getactfig',figNumber); end

demoSET = {...
    'fixreg' , 'ex1nfix'  , 'db2'  , 5 , {}  ; ...
    'fixreg' , 'noisdopp' , 'db5'  , 5 , {}  ; ...
    'fixreg' , 'nbumpr3'  , 'sym4' , 5 , {4} ; ...
    'fixreg' , 'nelec'    , 'sym4' , 5 , {3}   ...
    };
nbDEM = size(demoSET,1);
for k = 1:nbDEM
    paramDEM = demoSET(k,:);
    wdretool('demo',active_fig,paramDEM{:});
    wenamngr('Inactive',active_fig);
    if wshowdrv('pause',figNumber,wait_mode), return; end;
end

demoSET = {...
    'storeg' , 'ex1nsto'  , 'sym4' , 5 ,{}  ; ...
    'storeg' , 'noisdopp' , 'db5'  , 5 ,{}  ; ...
    'storeg' , 'noisbump' , 'db5'  , 5 ,{}  ; ...
    'storeg' , 'snblocr1' , 'sym4' , 5 ,{3} ; ...
    'storeg' , 'snbumpr1' , 'sym4' , 5 ,{3} ; ...
    'storeg' , 'snelec'   , 'sym4' , 5 ,{3}   ...
    };
nbDEM = size(demoSET,1);
for k = 1:nbDEM
    paramDEM = demoSET(k,:);
    wdretool('demo',active_fig,paramDEM{:});
    wenamngr('Inactive',active_fig);
    if k<nbDEM
      if wshowdrv('pause',figNumber,wait_mode), return; end;
    end
end

if figNumber==0
    wshowdrv('pause',figNumber,wait_mode);
    re1dtool('close',active_fig);
    delete(active_fig)
end
