function dguiiext(varargin)
%DGUIIEXT Demonstrates Image extension GUI tools in the Wavelet Toolbox.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 03-Jul-99.
%   Last Revision: 09-Dec-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.5 $  $Date: 2001/03/30 16:34:52 $

% Check arguments.
%=================
switch nargin
  case 0 , figNumber = 0; wait_mode = 1;
  case 2 ,   
    if isequal(varargin{1},'noGUI')
        figNumber = 0;
        wait_mode = varargin{2};
    else
        figNumber = varargin{1};
        wait_mode = 1;
    end
end

if wshowdrv('init',figNumber)
    if figNumber==0 
        active_fig = imgxtool;
	wenamngr('Inactive',active_fig);
    else
        active_fig = demoguim('startshow',figNumber,'imgxtool');
	wenamngr('Inactive',active_fig);
        wshowdrv('setactfig',figNumber,active_fig);
        return;
    end
end
if figNumber , active_fig = wshowdrv('getactfig',figNumber); end

demoSET = {...
 'woman2'  , 'ext'   , {'zpd' , [220,200] , 'both' , 'both'} ; ...
 'woman2'  , 'trunc' , {'nul' , [ 96, 96] , 'both' , 'both'} ; ...
 'wbarb'   , 'ext'   , {'sym' , [512,200] , 'right', 'both'} ; ...
 'noiswom' , 'ext'   , {'sym' , [512,512] , 'right', 'down'} ; ...
 'noiswom' , 'ext'   , {'ppd' , [512,512] , 'right', 'down'} ; ...
 'wbarb'   , 'ext'   , {'sym' , [512,512] , 'both' , 'both'} ; ...
 'facets'  , 'ext'   , {'ppd' , [512,512] , 'both' , 'both'} ; ...
 'mandel'  , 'ext'   , {'sym' , [512,512] , 'left' , 'both'}   ...
 };
nbDEM = size(demoSET,1);
for k = 1:nbDEM
    paramDEM = demoSET(k,:);
    imgxtool('demo',active_fig,paramDEM{:});
    wfigmngr('storeValue',active_fig,'File_Save_Flag',1);
    wenamngr('Inactive',active_fig);
    if k<nbDEM
      if wshowdrv('pause',figNumber,wait_mode), return; end;
    end
end

if figNumber==0
    wshowdrv('pause',figNumber,wait_mode);
    imgxtool('close',active_fig);
    delete(active_fig)
end

