function dguidw2d(varargin)
%DGUIDW2D Demonstrates discrete 2-D wavelet GUI tools in the Wavelet Toolbox.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-Mar-96.
%   Last Revision: 27-Jun-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
% $Revision: 1.11 $

% Check arguments.
%=================
switch nargin
  case 0 , figNumber = 0; wait_mode = 1;
  case 2 ,   
    if isequal(varargin{1},'noGUI')
        figNumber = 0;
        wait_mode = varargin{2};
    else
        figNumber = varargin{1};
        wait_mode = 1;
    end
end

if wshowdrv('init',figNumber)
    if figNumber==0
        active_fig = dw2dtool;
        wenamngr('Inactive',active_fig);
    else
        active_fig = demoguim('startshow',figNumber,'dw2dtool');
        wenamngr('Inactive',active_fig);
        wshowdrv('setactfig',figNumber,active_fig);
        return;
    end
end
if exist('wait_mode')~=1 , wait_mode = 1; end
if figNumber , active_fig = wshowdrv('getactfig',figNumber); end

dw2dmngr('demo',active_fig,'woman2','sym4',2);
wenamngr('Inactive',active_fig);
if wshowdrv('pause',figNumber,wait_mode), return; end;

tag_pop_declev  = 'Pop_DecLev';
tag_pop_viewm   = 'Pop_ViewM';
tag_pus_full    = str2mat(...
                        'Pus_Full.1','Pus_Full.2',...
                        'Pus_Full.3','Pus_Full.4'...
                        );
pop_handles     = findobj(active_fig,'style','popupmenu');
pus_handles     = findobj(active_fig,'style','pushbutton');
pop_viewm       = findobj(pop_handles,'tag',tag_pop_viewm);
pop_decm        = findobj(pop_handles,'tag',tag_pop_declev);
pus_full        = findobj(pus_handles,'tag',tag_pus_full(4,:));
cba_viewm       = get(pop_viewm,'Callback');
cba_decm        = get(pop_decm,'Callback');
cba_full        = get(pus_full,'Callback');

msg = str2mat(...
         'The present View mode is Square mode.', ...
        ['To change the Display mode use the corresponding popupmenu ' ...
         'in the middle of the window.'],...
         'Two view modes are available.'...
        );
if dguiwait('pause',figNumber,0,active_fig,msg); return; end

msg = ['We select the Tree Mode.'];
if dguiwait('pause',figNumber,0,active_fig,msg); return; end

set(pop_viewm,'value',2);
eval(cba_viewm);
if wshowdrv('pause',figNumber,wait_mode), return; end;

msg = ['We go back to the Square mode.'];
if dguiwait('pause',figNumber,0,active_fig,msg); return; end

set(pop_viewm,'value',1);
eval(cba_viewm);
if wshowdrv('pause',figNumber,wait_mode), return; end;


msg = str2mat(...
         'The four pushbuttons labelled [1 2 3 4] in the middle of the window', ...
         'allow to see Full Size for one of the four axes.', ...
         'Let''s display the decomposition (button 4) Full Size.' ...
        );
if dguiwait('pause',figNumber,0,active_fig,msg); return; end

eval(cba_full);
if wshowdrv('pause',figNumber,wait_mode), return; end;

msg = ['We select the decomposition at level 1.'];
if dguiwait('pause',figNumber,0,active_fig,msg); return; end

set(pop_decm,'value',1);
eval(cba_decm);
if wshowdrv('pause',figNumber,wait_mode), return; end;

msg = ['We go back to the Square mode.'];
if dguiwait('pause',figNumber,0,active_fig,msg); return; end

eval(cba_full);
if wshowdrv('pause',figNumber,wait_mode), return; end;

msg = ['We restore the decomposition at level 2.'];
if dguiwait('pause',figNumber,0,active_fig,msg); return; end

set(pop_decm,'value',2);
eval(cba_decm);
if wshowdrv('pause',figNumber,wait_mode), return; end;

msg = 'The Compress pushbutton is used to call the compression tool.';
if dguiwait('pause',figNumber,0,active_fig,msg); return; end

out2 = dw2dmngr('comp',active_fig);
wenamngr('Inactive',out2);

msg = 'We compress the image with the default options.';
if dguiwait('pause',figNumber,0,out2,msg); return; end

dw2dcomp('compress',out2,active_fig);
if wshowdrv('pause',figNumber,wait_mode), return; end;
delete(out2); drawnow; pause(2)
dw2dmngr('return_comp',active_fig,0);
wenamngr('Inactive',active_fig);

msg = 'The De-noise pushbutton is used to call the de-noising tool.';
if dguiwait('pause',figNumber,0,active_fig,msg); return; end

out3 = dw2dmngr('deno',active_fig);
wenamngr('Inactive',out3);

msg = 'We de-noise the image with the default options.';
if dguiwait('pause',figNumber,0,out3,msg); return; end

dw2ddeno('denoise',out3,active_fig);
if wshowdrv('pause',figNumber,wait_mode), return; end;
delete(out3); drawnow; pause(2)
dw2dmngr('return_deno',active_fig,0);
wenamngr('Inactive',active_fig);

msg = 'The Statistics pushbutton is used to call the statistics tool.';
if dguiwait('pause',figNumber,0,active_fig,msg); return; end

out4 = dw2dmngr('stat',active_fig);
dw2dstat('demo',out4);
wenamngr('Inactive',out4);
if wshowdrv('pause',figNumber,wait_mode), return; end;
delete(out4); drawnow; pause(2)

msg = 'The Histograms pushbutton is used to call the histograms tool.';
if dguiwait('pause',figNumber,0,active_fig,msg); return; end

out5 = dw2dmngr('hist',active_fig);
dw2dhist('demo',out5);
wenamngr('Inactive',out5);
if wshowdrv('pause',figNumber,wait_mode), return; end;

delete(out5); drawnow; pause(2)
if figNumber==0
    wshowdrv('pause',figNumber,wait_mode);
    dw2dtool('close',active_fig);
    delete(active_fig)
end
