function dguide1d(varargin)
%DGUIDE1D Demonstrates 1-D density estimation GUI tools in the Wavelet Toolbox.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 03-Jul-99.
%   Last Revision: 04-Jul-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.5 $  $Date: 2001/03/30 16:34:49 $

% Check arguments.
%=================
switch nargin
  case 0 , figNumber = 0; wait_mode = 1;
  case 2 ,   
    if isequal(varargin{1},'noGUI')
        figNumber = 0;
        wait_mode = varargin{2};
    else
        figNumber = varargin{1};
        wait_mode = 1;
    end
end

if wshowdrv('init',figNumber)
    if figNumber==0 
        active_fig = de1dtool;
	wenamngr('Inactive',active_fig);
    else
        active_fig = demoguim('startshow',figNumber,'de1dtool');
	wenamngr('Inactive',active_fig);
        wshowdrv('setactfig',figNumber,active_fig);
        return;
    end
end
if figNumber , active_fig = wshowdrv('getactfig',figNumber); end

demoSET = {...
    'denest' , 'ex1cusp1' , 'sym4'  , 5 ; ...
    'denest' , 'ex2cusp1' , 'sym6'  , 5 ; ...
    'denest' , 'ex1cusp2' , 'sym4'  , 5 ; ...
    'denest' , 'ex2cusp2' , 'coif1' , 5 ; ...
    'denest' , 'ex1gauss' , 'sym3'  , 5 ; ...
    'denest' , 'ex2gauss' , 'sym4'  , 5   ...
    };

nbDEM = size(demoSET,1);
for k = 1:nbDEM
    paramDEM = demoSET(k,:);
    wdretool('demo',active_fig,paramDEM{:});
    wenamngr('Inactive',active_fig);
    if k<nbDEM
      if wshowdrv('pause',figNumber,wait_mode), return; end;
    end
end

if figNumber==0
    wshowdrv('pause',figNumber,wait_mode);
    de1dtool('close',active_fig);
    delete(active_fig)
end
