function dguicwim(varargin)
%DGUICWIM Demonstrates complex continuous 1-D wavelet GUI tools in the Wavelet Toolbox. 

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-Jun-99.
%   Last Revision: 27-Sep-2000.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.6 $  $Date: 2001/03/30 16:34:48 $

% Check arguments.
%=================
switch nargin
  case 0 , figNumber = 0; wait_mode = 1;
  case 2 ,   
    if isequal(varargin{1},'noGUI')
        figNumber = 0;
        wait_mode = varargin{2};
    else
        figNumber = varargin{1};
        wait_mode = 1;
    end
end

if wshowdrv('init',figNumber)
    if figNumber==0 
        active_fig = cwimtool;
	wenamngr('Inactive',active_fig);
    else
        active_fig = demoguim('startshow',figNumber,'cwimtool');
	wenamngr('Inactive',active_fig);
        wshowdrv('setactfig',figNumber,active_fig);
        return;
    end
end
if figNumber , active_fig = wshowdrv('getactfig',figNumber); end

% Initialization.
%----------------
handles = wfigmngr('getValue',active_fig,['CW1D_handles']);
UIC = handles.hdl_UIC;
pop_ccm = UIC.pop_ccm;
pop_pal = cbcolmap('get',active_fig,'pop_pal');
cba_ccm = get(pop_ccm,'Callback');
cba_pal = get(pop_pal,'Callback');
map_val = get(pop_pal,'Value');
if map_val==2 , map_val = 1; else , map_val =2; end
str_col = get(pop_pal,'String');
str_col = deblank(str_col(map_val,:));

cw1dmngr('demo',active_fig,'cuspamax','cgau2',1,1,32,1);
wenamngr('Inactive',active_fig);
msg = str2mat(...
        ['To change the Colormap use the popupmenu at the ' ...
         'bottom right of the window.'], ...
        ['We select the ' str_col '  colormap']...
        );
if dguiwait('pause',figNumber,0,active_fig,msg); return; end

set(pop_pal,'value',map_val);
eval(cba_pal);

if wshowdrv('pause',figNumber,wait_mode), return; end;

msg = str2mat(...
        ['To change the Coloration Mode use the popupmenu in the ' ...
         'middle of the window.'], ...
         'The present mode is the (init+ by scale) mode. ', ...
         'We select the (init+ all scales) mode.'...
        );
if dguiwait('pause',figNumber,0,active_fig,msg); return; end

set(pop_ccm,'value',2);
eval(cba_ccm);

if wshowdrv('pause',figNumber,wait_mode), return; end;

cw1dmngr('demo',active_fig,'brkintri','cmor1-0.1',1,1,64,1);
wenamngr('Inactive',active_fig);
if wshowdrv('pause',figNumber,wait_mode), return; end;

msg = 'We select the hot colormap';
if dguiwait('pause',figNumber,0,active_fig,msg); return; end

set(pop_pal,'value',4);
eval(cba_pal);
set([pop_ccm;pop_pal],'Enable','On');
if figNumber==0
    wshowdrv('pause',figNumber,wait_mode);
    cwimtool('close',active_fig);
    delete(active_fig)
end
