function dguicf2d(varargin)
%DGUICF2D Demonstrates 2-D wavelet coefficients selection GUI tools in the Wavelet Toolbox.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 03-Jul-99.
%   Last Revision: 06-Jul-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.5 $  $Date: 2001/03/30 16:34:47 $

% Check arguments.
%=================
switch nargin
  case 0 , figNumber = 0; wait_mode = 1;
  case 2 ,   
    if isequal(varargin{1},'noGUI')
        figNumber = 0;
        wait_mode = varargin{2};
    else
        figNumber = varargin{1};
        wait_mode = 1;
    end
end

if wshowdrv('init',figNumber)
    if figNumber==0 
        active_fig = cf2dtool;
	wenamngr('Inactive',active_fig);
    else
        active_fig = demoguim('startshow',figNumber,'cf2dtool');
	wenamngr('Inactive',active_fig);
        wshowdrv('setactfig',figNumber,active_fig);
        return;
    end
end
if figNumber , active_fig = wshowdrv('getactfig',figNumber); end

demoSET = {...
  'noiswom' , 'haar'   , 3, {'Global'}  ; ...
  'noiswom' , 'haar'   , 3, {'Stepwise',[144,100,3144]};  ...
  'detfingr', 'sym4'   , 3, {'Global'}  ; ...
  'detfingr', 'sym4'   , 3, {'Stepwise',[1849,200,6149]}; ...
  'facets'  , 'bior6.8', 5, {'Global'}  ; ...
  'facets'  , 'bior6.8', 5, {'Stepwise',[576,200,4076]}  ...
  };
nbDEM = size(demoSET,1);

for k = 1:nbDEM
    paramDEM = demoSET(k,:);
    cf2dtool('demo',active_fig,paramDEM{:});
    wenamngr('Inactive',active_fig);
    if k<nbDEM
      if wshowdrv('pause',figNumber,wait_mode), return; end;
    end
end

if figNumber==0
    wshowdrv('pause',figNumber,wait_mode);
    cf2dtool('close',active_fig);
    delete(active_fig)
end
