function dguicf1d(varargin)
%DGUICF1D Demonstrates 1-D wavelet coefficients selection GUI tools in the Wavelet Toolbox.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 03-Jul-99.
%   Last Revision: 06-Jul-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.5 $  $Date: 2001/03/30 16:34:47 $

% Check arguments.
%=================
switch nargin
  case 0 , figNumber = 0; wait_mode = 1;
  case 2 ,   
    if isequal(varargin{1},'noGUI')
        figNumber = 0;
        wait_mode = varargin{2};
    else
        figNumber = varargin{1};
        wait_mode = 1;
    end
end

if wshowdrv('init',figNumber)
    if figNumber==0 
        active_fig = cf1dtool;
	wenamngr('Inactive',active_fig);
    else
        active_fig = demoguim('startshow',figNumber,'cf1dtool');
	wenamngr('Inactive',active_fig);
        wshowdrv('setactfig',figNumber,active_fig);
        return;
    end
end
if figNumber , active_fig = wshowdrv('getactfig',figNumber); end
toolATTR = wfigmngr('getValue',active_fig,'ToolATTR');
hdl_UIC  = toolATTR.hdl_UIC;
chk_sho  = hdl_UIC.chk_sho;
cba_chk  = get(chk_sho,'Callback');

% Demo 1.
%--------
paramDEM = {'freqbrk','db5',5,{'Global'}};
cf1dtool('demo',active_fig,paramDEM{:});
wenamngr('Inactive',active_fig);
set(chk_sho,'value',1);
eval(cba_chk);
if wshowdrv('pause',figNumber,wait_mode), return; end;

% Demo 2.
%--------
paramDEM = {'noisbloc','sym4',5,{'Global'}};
cf1dtool('demo',active_fig,paramDEM{:});
wenamngr('Inactive',active_fig);
set(chk_sho,'value',1);
eval(cba_chk);
if wshowdrv('pause',figNumber,wait_mode), return; end;

% Demo 3.
%--------
paramDEM = {'noisbloc','sym4',5,{'Stepwise'}};
cf1dtool('demo',active_fig,paramDEM{:});
wenamngr('Inactive',active_fig);
if wshowdrv('pause',figNumber,wait_mode), return; end;

% Demo 4.
%--------
paramDEM = {'noisbump','sym4',5,{'Stepwise'}};
cf1dtool('demo',active_fig,paramDEM{:});
wenamngr('Inactive',active_fig);
if wshowdrv('pause',figNumber,wait_mode), return; end;

% Demo 5.
%--------
paramDEM = {'nelec','db3',5,{'Global'}};
cf1dtool('demo',active_fig,paramDEM{:});
wenamngr('Inactive',active_fig);
set(chk_sho,'value',1);
eval(cba_chk);

if figNumber==0
    wshowdrv('pause',figNumber,wait_mode);
    cf1dtool('close',active_fig);
    delete(active_fig)
end
