function out1 = demoscen(option,in2,in3,in4,in5,in6)
%DEMOSCEN Demonstrates typical wavelet 1-D scenarios using the Wavelet Toolbox. 
%   DEMOSCEN shows Short 1-D scenario demo.

%   DEMOSCEN('auto') shows Short 1-D scenario demo
%   in automatic mode.
%
%   DEMOSCEN('loop') shows Short 1-D scenario demo
%   in loop mode.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-Mar-96.
%   Last Revision: 05-Jul-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.14 $ $Date: 2001/03/30 16:34:46 $

% Tag property of objects.
%------------------------
tag_dem_tool  = 'Demo_Tool';
tag_dmsgfig   = 'Wdmsgfig';
tag_btn_close = 'Demo_Close'; % tag for window

if nargin==0 , option = 'dw1d'; in2 = 1; in3 = 1; end

switch option
  case 'dw1d'
    % in2 = wait_mode
    % in3 = msg_win (optional)
    %-------------------------
    demoname = ['dsce' option];
    wait_mode  = in2;
    gui = wait_mode;
    win_msg = 1;
    if nargin==3
        if in3==1 , win_msg = 1; else , win_msg = 0; end
    end
    if ~isequal(gui,0)
        demomode = 'command';
        addclose = [mfilename '(''close'');'];
        wshowdrv(demoname,demomode,addclose);
    else
        feval(demoname,'noGUI',wait_mode,win_msg);
    end

  case 'msg'
    % in2 = figNumber
    % in3 = wait_mode
    % in4 = num msg
    % in5 = win_msg (optional)
    % in6 = win_view (optional)
    %---------------------------
    figNumber = in2;
    wait_m  = in3;
    num_msg = in4;
    if nargin>3
            win_msg = in5;
            if nargin==6
                win_view = in6;
            else
                win_view = 0;
            end
    else
            win_msg = 1; win_view = 0;
    end
    tim_msg = 8;
    max_lig = 6;
    ok_msg  = 0;

    if      num_msg==1
    str1 = 'This demo shows the 1-D wavelet capabilities of the ';
    str2 = 'Wavelet GUI tools. The scenario supposes that we want to';
    str3 = 'de-noise or compress a 1-D signal. In this example, we ';
    str4 = 'decompose a simple synthetic noisy Doppler signal using ';
    str5 = 'the Symlet 4 wavelet (sym4) into five levels.';
    msg  = str2mat(str1,str2,str3,str4,str5);
    ok_msg = 1;

    elseif  num_msg==2
    str1 = 'The full decomposition appears, with the signal denoted s at the top.';
    str2 = 'This signal is equal to the sum of the coarsest approximation (a5)';
    str3 = 'and the details at levels 1 to 5 (d1 ... d5).';
    str4 = 'i.e.,  s = a5 + d5 + d4 + d3 + d2 + d1';
    str5 = 'Since sym4 is an orthogonal wavelet, the decomposition is orthogonal.';
    msg  = str2mat(str1,str2,str3,str4,str5,'$');

    str1 = 'How do we select the wavelet and decomposition level?';
    msg  = str2mat(msg,str1,'$');

    str1 = 'For de-noising or compression, both the decomposition level and ';
    str2 = 'wavelet are useful tuning parameters.';
    str3 = 'Recall that the de-noised or compressed signal is equal to';
    str4 = 'the coarsest approximation + some signal reconstructed using the ';
    str5 = 'thresholded detail coefficients.';
    msg  = str2mat(msg,str1,str2,str3,str4,str5,'$');

    str1 = 'Often the wavelet choice is not crucial, and any "short" wavelet';
    str2 = 'except Haar is a good starting point.';
    msg  = str2mat(msg,str1,str2,'$');

    str1 = 'Having selected a wavelet, the decomposition level needs to be selected.';
    str2 = 'To study this, let us change to the Separate display mode.';
    msg  = str2mat(msg,str1,str2);
    ok_msg = 1;

    elseif  num_msg==6
    str1 = 'As a rule of thumb, we can select the decomposition level in such';
    str2 = 'a way that the corresponding approximation is noise free. In this';
    str3 = 'example 4 or 5 are good candidates, since the approximations at levels';
    str4 = '1 to 3 are clearly noisy. In addition, the detail d5 contains';
    str5 = 'significant noise as it can be seen inspecting the second half of the';
    str6 = 'detail, so 5 should be a good value for the decomposition level.';
    msg  = str2mat(str1,str2,str3,str4,str5,str6,'$');

    str1 = 'The Wavelet GUI provides a flexible and configurable';
    str2 = 'interface.';
    msg  = str2mat(msg,str1,str2,'$');

    str1 = 'In the current view, one can see the wavelet coefficients, cfs. We';
    str2 = 'focus on the coefficients, selecting Show and Scroll display mode,';
    str3 = 'selecting the approximation at level 5 and using the More Display';
    str4 = 'Options and removing the Detail Axes.';
    msg  = str2mat(msg,str1,str2,str3,str4);
    ok_msg = 1;

    elseif  num_msg==8
    str1 = 'The time-scale pattern shows that the';
    str2 = 'deterministic part of the signal is concentrated in a few big coefficients,';
    str3 = 'and noise corrupts all the time-scale representation.';
    str4 = 'To reinforce this, use the coloration  mode init + all levels + abs';
    str5 = 'in order to rescale globally the absolute coefficients.';
    msg  = str2mat(str1,str2,str3,str4,str5);
    ok_msg = 1;

    elseif  num_msg==9
    str1 = 'Clicking on the Histograms button and selecting all the detail coefficients,';
    str2 = 'we can see that the detail coefficients are approximately Gaussian N(0,1)';
    str3 = 'except for extreme values outside the interval [-4,4] which are';
    str4 = 'linked to the decomposition of the deterministic part of the signal.';
    msg  = str2mat(str1,str2,str3,str4);
    ok_msg = 1;

    elseif  num_msg==10
    str1 = 'The de-noising or compression procedure acts on these coefficients killing';
    str2 = 'the lowest coefficients in absolute value terms and keeping large values.';
    msg  = str2mat(str1,str2);
    ok_msg = 1;

    elseif  num_msg==11
    str1 = 'Compression.';
    str2 = '------------';
    str3 = 'We press the Compress button, and the compression window appears.';
    str4 = 'This allows the user to select the threshold value with respect to';
    str5 = 'two design parameters:';
    msg  = str2mat(str1,str2,str3,str4,str5);
    ok_msg = 1;

    elseif  num_msg==12
    str1 = '- the retained energy in percent which is equal to 100 times';
    str2 = 'the square norm of the compressed signal over the square norm of the';
    str3 = 'original signal (magenta line on the left);';
    msg  = str2mat(str1,str2,str3,'$');
    str4 = '- the number of zeros in percent which is equal to the percentage of zeros of';
    str5 = 'the wavelet representation of the compressed signal (blue line on the left).';
    str6 = 'The threshold default value given by the toolbox in the 1-D case is the one';
    str7 = 'for which the two previously defined design parameters are approximately the';
    str8 = 'same.';
    msg  = str2mat(msg,str4,str5,str6,str7,str8,'$');
    str1 = 'Then compression using the threshold default value leads a smoothed signal,';
    str2 = 'and the explanation of how the compression works is clear from the';
    str3 = 'comparison of original and thresholded coefficients in the time-scale';
    str4 = 'representations.';
    msg  = str2mat(msg,str1,str2,str3,str4);
    ok_msg = 1;

    elseif  num_msg==13
    str1 = 'You can then iterate choosing the threshold value or the retained energy';
    str2 = 'or the number of zeros. A modification of each of the three parameters';
    str3 = 'automatically updates the other two.';
    msg  = str2mat(str1,str2,str3);
    ok_msg = 1;

    elseif  num_msg==14
    str1 = 'To learn more about the compression procedure we select';
    str2 = 'the By-Level thresholding mode.';
    str3 = 'The detail coefficients are thresholded according to the thresholds represented';
    str4 = 'by the yellow lines on the left. With respect to the previous mode, this one';
    str5 = 'allows level-dependent threshold values leading to additional flexibility.';
    str6 = 'The resulting compressed signal can be found in the following figure.';
    msg  = str2mat(str1,str2,str3,str4,str5,str6);
    ok_msg = 1;

    elseif  num_msg==15
    str1 = 'De-noising.';
    str2 = '-----------';
    str3 = 'The design objective is to recover the signal or to remove noise,';
    str4 = 'without reference to an original interesting signal which is supposed to be';
    str5 = 'unknown. It is assumed that additive noise corrupts the signal to be';
    str6 = 'recovered, and is supposed to be stationary (at least at each scale).';
    msg  = str2mat(str1,str2,str3,str4,str5,str6,'$');

    str1 = 'The main ideas for de-noising and for compression are the same. The differences';
    str2 = 'are located at two points:';
    str3 = '- soft thresholding (shrinkage) is often used instead of the more crude';
    str4 = 'hard thresholding.';
    str5 = '- the noise structure (scaled or unscaled white noise, coloured noise) is of';
    str6 = 'interest.';
    msg  = str2mat(msg,str1,str2,str3,str4,str5,str6,'$');

    str1 = 'The GUI tools for de-noising are similar to the Compression tools. ';
    str2 = ' ';
    str3 = 'When you push on De-noise, the de-noising window appears,';
    str4 = 'we apply the default selection.';
    msg  = str2mat(msg,str1,str2,str3,str4);
    ok_msg = 1;

    elseif  num_msg==18
    str1 = 'As can be seen, the procedure keeps roughly the highest coefficients.';
    str2 = 'Then using the same default, we can show the differences between';
    str3 = 'soft and hard thresholding.';
    msg  = str2mat(str1,str2,str3);
    ok_msg = 1;

    elseif  num_msg==19
    str1 = ' ';
    str2 = ' ';
    msg  = str2mat(str1,str2);
    ok_msg = 1;

    elseif  num_msg==20
    str1 = 'Now we close the de-noising window, update the de-noised signal and compare';
    str2 = 'the two signals in full size.';
    msg  = str2mat(str1,str2);
    ok_msg = 1;

    end

    if ok_msg
        loop = 1;
        while loop
          col1    = msg(:,1)';
          nb_lin  = length(col1);
          ind     = findstr(col1,'$');
          if ~isempty(ind)
              lig = ind(1);
              if lig>max_lig+1
                  beg = lig;
                  tmp = msg(max_lig+1:nb_lin,:);
                  msg = msg(1:max_lig,:);
              else
                  beg = lig+1;
                  tmp = msg(beg:nb_lin,:);
                  msg = msg(1:lig-1,:);
              end
          elseif nb_lin>max_lig
              tmp = msg(max_lig+1:nb_lin,:);
              msg = msg(1:max_lig,:);
          else
              loop = 0;
          end

          if win_msg
              dmsgfun('create',msg,win_view);
          else
              disp(msg);
          end
          tim_msg = 1.7*size(msg,1);
          if wait_m==1
              out1 = wshowdrv('pause',figNumber,wait_m,tim_msg);
              if out1 , break; end
          else              
              out1 = wshowdrv('pause',figNumber,wait_m,tim_msg);
              if out1 , break; end
          end
          if loop , msg = tmp; end
        end
    end

  case 'auto'
    %**************************************%
    %** OPTION = 'auto' - automatic mode **%
    %**************************************%
    stop = 0;
    while stop==0
        demoscen('dw1d',0,1);
        stop = 1;
        if nargin==2 & strcmp(in2,'loop') , stop = 0 ; end
    end

  case 'loop'
    %*******************************************%
    %** OPTION = 'loop' - loop automatic mode **%
    %*******************************************%
    demoscen('auto','loop');

  case 'compile'
    %*********************************************%
    %** OPTION = 'compile' - for precompilation **%
    %*********************************************%

  case 'startshow'
    %***************************************************%
    %** OPTION = 'startshow' - used to start wshowdrv **%
    %***************************************************%
    figNumber = in2;
    out1 = wmemtool('rmb',figNumber,'Activefig',1);
    if isempty(out1)
        out1 = feval(in3);
        wmemtool('wmb',figNumber,'Activefig',1,out1);
        hndlList  = get(figNumber,'Userdata');
        closeHndl = hndlList(7);
        callbackStr = get(closeHndl,'Callback');
        winact = num2mstr(out1);

        str1 = ['fig = find(get(0,''children'')==' winact ');'];
        str2 = ['if ~isempty(fig) , clear fig ;' ...
                 in3 '(''close'',' winact '); delete(' winact '); end;'];
        set(closeHndl,'Callback',[str1,str2,callbackStr],'tag',tag_btn_close);
    end

  case 'close'
    %***********************************************%
    %** OPTION = 'close' - close demoscen window  **%
    %***********************************************%
    mousefrm(0,'watch')
    delete(wfindobj('figure','tag',tag_dmsgfig));

    win_ini = wfindobj('figure','tag',tag_dem_tool);
    if ~isempty(win_ini)
        pus_handles = findobj(win_ini,'Style','pushbutton');
        set(pus_handles,'Enable','on');
    else
        mextglob('clear');
        wtbxmngr('clear');
    end
    mousefrm(0,'arrow');

  otherwise
    errargt(mfilename,'Unknown Option','msg');
    error('*');
end

% Reset the LASTERR function
lasterr('');

