function tbxStruct = demos
%DEMOS Demo list for the Wavelet Toolbox. 

% Last Revision: 15-Sep-2000.
% Copyright 1995-2001 The MathWorks, Inc.
% $Revision: 1.16 $ $Date: 2001/04/02 14:06:40 $
 
if nargout == 0, demo toolbox; return; end

tbxStruct.Name = 'Wavelet';
tbxStruct.Type = 'toolbox';
tbxStruct.Help = { ...
   ' The Wavelet Toolbox extends the MATLAB'
   ' Technical Computing Environment and '
   ' provides a comprehensive collection of'
   ' routines for examining local, multiscale,'
   ' or nonstationary phenomena.'
   ' '
   ' Wavelet methods offer additional insight'
   ' and performance in any application where'
   ' Fourier techniques have been used.'
   ' The toolbox is useful in many signal and'
   ' image processing applications, including'
   ' speech and audio processing, communications,'
   ' geophysics, finance and medicine.'
   ' '
   ' The Wavelet Toolbox provides point-and-click'
   ' graphical tools and command line functions'
   ' for analysis, synthesis, de-noising'
   ' and compression of signals and images.'};

tbxStruct.DemoList = { ...
   'Slideshow demos','';     
   '   Wavelet 1-D',                     'democmdm(''dw1d'',[])';
   '   Continuous Wavelet 1-D',          'democmdm(''cw1d'',[])';
   '   Wavelet 2-D',                     'democmdm(''dw2d'',[])';
   '   Compression',                     'democmdm(''comp'',[])';
   '   De-noising',                      'democmdm(''deno'',[])';
   '   Wavelet Packets',                 'democmdm(''wpck'',[])';
   '   Mallat Algorithm',                'democmdm(''mala'',[])';
   '   Cascade Algorithm',               'democmdm(''casc'',[])';
   '   Border Distortion',               'democmdm(''extm'',[])';
   'Graphical User Interface demos',''; 
   '   Wavelet 1-D',                     'demoguim(''dw1d'',[])';
   '   Wavelet Packet 1-D',              'demoguim(''wp1d'',[])';
   '   Continuous Wavelet 1-D',          'demoguim(''cw1d'',[])';
   '   Continuous Wavelet 1-D (complex)','demoguim(''cwim'',[])';
   '   Wavelet 2-D',                     'demoguim(''dw2d'',[])';
   '   Wavelet Packet 2-D',              'demoguim(''wp2d'',[])';
   '   Wavelet Display',                 'demoguim(''wvdi'',[])';
   '   Wavelet Packet Display',          'demoguim(''wpdi'',[])';
   '   Stationary Wavelet 1-D',          'demoguim(''sw1d'',[])';
   '   Wavelet Density estimation',      'demoguim(''de1d'',[])';
   '   Wavelet Regression estimation',   'demoguim(''re1d'',[])';
   '   Wavelet Coefficients 1-D tool',   'demoguim(''cf1d'',[])';
   '   Stationary Wavelet 2-D',          'demoguim(''sw2d'',[])'; 
   '   Wavelet Coefficients 2-D tool',   'demoguim(''cf2d'',[])';
   '   Signal extension tool',           'demoguim(''sext'',[])';   
   '   Image extension tool',            'demoguim(''iext'',[])'
	};

