function out1 = demoguim(option,in2,in3,in4)
%DEMOGUIM Main GUI-mode demos menu in the Wavelet Toolbox.
%   DEMOGUIM creates the window for GUI mode demos.

%   DEMOGUIM('auto') shows all the GUI mode demos
%   in automatic mode.
%
%   DEMOGUIM('loop') shows all the GUI mode demos
%   in loop mode.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-Mar-96.
%   Last Revision: 09-Jul-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.15 $ $Date: 2001/03/30 16:34:44 $


if nargin==0 , option = 'create'; end

tag_dem_tool  = 'Demo_Tool';
tag_guim_tool = 'Guim_Tool';
tag_btn_close = 'Demo_Close'; % tag for window
tag_sub_close = 'Guim_Close'; % tag for sub_window

switch option
    case 'create'
        win = wfindobj('figure','tag',tag_guim_tool);
        if ~isempty(win) , return; end

        % Waiting Frame construction & begin waiting.
        %--------------------------------------------
        mousefrm(0,'watch');
 
        % Globals initialization.
        %-------------------------
        [ShiftTop_Fig,Def_Btn_Height,Def_Btn_Width] = ...
                mextglob('get','ShiftTop_Fig','Def_Btn_Height','Def_Btn_Width');

        % Wavelet main window initialization.
        %------------------------------------
        win_units   = 'pixels';
        Screen_Size = get(0,'ScreenSize');
        x_unit      = Def_Btn_Width/8;
        y_unit      = Def_Btn_Height/2;
        btn_width   = 22*x_unit;
        bdx         = x_unit;
        bdy         = y_unit;
        mulY        = 2.5;
        btn_heigth  = 3*y_unit;
        if Screen_Size(3)<900
            btn_width = 24*x_unit;
            mulY      = 3;
        end
        btn_left   = 2*bdx;
        fra_left   = bdx;
        fra_width  = btn_width+2*bdx;
        dif_heigth = btn_heigth+0*y_unit;
        win_width  = 2*fra_width+6*bdx;

        % Position property of objects.
        %------------------------------
        btn_low   = 2*bdy;
        w_uic     = 18*x_unit;
        x_uic     = (win_width-w_uic)/2;
        pos_close = [x_uic, btn_low , w_uic , btn_heigth];

        % Left side.
        %-----------
        countAllBtn = 0;
        countBtn  = 0;
        fra_low   = pos_close(2)+pos_close(4)+2*bdy;
        btn_low   = fra_low+bdy/2;
        pos_wpdi  = [btn_left, btn_low , btn_width , btn_heigth];
        countBtn  = countBtn+1;

        btn_low   = btn_low+dif_heigth;
        pos_wvdi  = [btn_left , btn_low , btn_width , btn_heigth];
        countBtn  = countBtn+1;

        h_fra     = countBtn*btn_heigth+0*(countBtn-1)*y_unit+mulY*bdy/2;
        pos_fra3  = [fra_left, fra_low, fra_width, h_fra];
	
	txt3_heigth = btn_heigth/2;
	txt3_width  = btn_width/3;
	txt3_low    = (fra_low + h_fra) - (txt3_heigth/2);
	txt3_left   = fra_left + (fra_width - txt3_width)/2;
        pos_txt3    = [txt3_left, txt3_low, txt3_width, txt3_heigth];
	
        countAllBtn = countAllBtn+countBtn;
        countBtn  = 0;
        fra_low   = pos_fra3(2)+pos_fra3(4)+ 2*bdy;
        btn_low   = fra_low+bdy/2;
        pos_wp2d  = [btn_left , btn_low , btn_width , btn_heigth];
        countBtn  = countBtn+1;

        btn_low   = btn_low+dif_heigth;
        pos_dw2d  = [btn_left , btn_low , btn_width , btn_heigth];
        countBtn  = countBtn+1;

        h_fra     = countBtn*btn_heigth+0*(countBtn-1)*y_unit+mulY*bdy/2;
        pos_fra2  = [fra_left, fra_low, fra_width, h_fra];
	
	txt2_heigth = btn_heigth/2;
	txt2_width  = btn_width/2;
	txt2_low    = (fra_low + h_fra) - (txt2_heigth/2);
	txt2_left   = fra_left + (fra_width - txt2_width)/2;
        pos_txt2    = [txt2_left, txt2_low, txt2_width, txt2_heigth];
	
        countAllBtn = countAllBtn+countBtn;
        countBtn  = 0;
        fra_low   = pos_fra2(2)+pos_fra2(4)+ 2*bdy;
        btn_low   = fra_low+bdy/2;
        pos_cwim  = [btn_left , btn_low , btn_width , btn_heigth];
        countBtn  = countBtn+1;

        btn_low   = btn_low+dif_heigth;
        pos_cw1d  = [btn_left , btn_low , btn_width , btn_heigth];
        countBtn  = countBtn+1;

        btn_low   = btn_low+dif_heigth;
        pos_wp1d  = [btn_left , btn_low , btn_width , btn_heigth];
        countBtn  = countBtn+1;

        btn_low   = btn_low+dif_heigth;
        pos_dw1d  = [btn_left , btn_low , btn_width , btn_heigth];
        countBtn  = countBtn+1;

        h_fra     = countBtn*btn_heigth+0*(countBtn-1)*y_unit+mulY*bdy/2;
        pos_fra1  = [fra_left, fra_low, fra_width, h_fra];
	
	txt1_heigth = btn_heigth/2;
	txt1_width  = btn_width/2;
	txt1_low    = (fra_low + h_fra) - (txt1_heigth/2);
	txt1_left   = fra_left + (fra_width - txt1_width)/2;
        pos_txt1    = [txt1_left, txt1_low, txt1_width, txt1_heigth];

        % Right side.
        %------------
        transX   = fra_width+4*x_unit;
        transPOS = [transX 0 0 0];
        pos_fra4 = pos_fra1 + transPOS;
        pos_fra5 = pos_fra2 + transPOS;
        pos_fra6 = pos_fra3 + transPOS;        
        pos_txt4 = pos_txt1 + transPOS;
        add_wid  = btn_width/6;
        pos_txt4 = pos_txt4 + add_wid*[-0.5,0,1,0];
        pos_txt5 = pos_txt2 + transPOS;
        pos_txt5 = pos_txt5 + add_wid*[-0.5,0,1,0];
        pos_txt6 = pos_txt3 + transPOS;        
        pos_sw1d = pos_dw1d + transPOS;
        pos_dens = pos_wp1d + transPOS;
        pos_regr = pos_cw1d + transPOS;
        pos_cf1d = pos_cwim + transPOS;
        pos_sw2d = pos_dw2d + transPOS;
        pos_cf2d = pos_wp2d + transPOS;
        pos_sext = pos_wvdi + transPOS;
        pos_iext = pos_wpdi + transPOS;


        % GUIM main window initialization.
        %---------------------------------
        win_width  = 2*fra_width+6*bdx;
	win_height = pos_fra1(4)+pos_fra2(4)+pos_fra3(4)+ ...
                     10*bdy+pos_close(4);
        pos_win    = [Screen_Size(3)*0.01, ...
                      Screen_Size(4)-win_height-ShiftTop_Fig, ...
                      win_width, ...
                      win_height ...
                      ];
        figName    = 'Gui mode demo';

        win_demoguim = wfigmngr('init',         ...
                          'Name',figName,       ...
                          'Unit',win_units,     ...
                          'Position',pos_win,   ...
                          'Visible','On',       ...
                          'Tag',tag_guim_tool   ...
                          );
        out1 = win_demoguim;
        str_win_demoguim = int2str(win_demoguim);
	
        % String property of objects.
        %----------------------------
        str_dw1d = 'Wavelet 1-D';
        str_wp1d = 'Wavelet Packet 1-D';
        str_cw1d = 'Continuous Wavelet 1-D';
        str_cwim = 'Complex Continuous Wavelet 1-D';
        str_dw2d = 'Wavelet 2-D';
        str_wp2d = 'Wavelet Packet 2-D';
        str_wvdi = 'Wavelet Display';
        str_wpdi = 'Wavelet Packet Display';
        str_sw1d = 'SWT Denoising 1-D';
        str_dens = 'Density Estimation 1-D';
        str_regr = 'Regression Estimation 1-D';
        str_cf1d = 'Wavelet Coefficients Selection 1-D';
        str_sw2d = 'SWT Denoising 2-D';
        str_cf2d = 'Wavelet Coefficients Selection 2-D';
        str_sext = 'Signal Extension';
        str_iext = 'Image Extension';
        str_close= 'Close';
	str_fra1 = 'One-Dimensional';
	str_fra2 = 'Two-Dimensional';
	str_fra3 = 'Display';
	str_fra4 = 'Specialized Tools 1-D';
	str_fra5 = 'Specialized Tools 2-D';
	str_fra6 = 'Extension';
	
        % Callback property of objects.
        %------------------------------
        cba_dw1d  = [mfilename '(''dw1d'',' str_win_demoguim ');'];
        cba_wp1d  = [mfilename '(''wp1d'',' str_win_demoguim ');'];
        cba_cw1d  = [mfilename '(''cw1d'',' str_win_demoguim ');'];
        cba_cwim  = [mfilename '(''cwim'',' str_win_demoguim ');'];
        cba_dw2d  = [mfilename '(''dw2d'',' str_win_demoguim ');'];
        cba_wp2d  = [mfilename '(''wp2d'',' str_win_demoguim ');'];
        cba_wvdi  = [mfilename '(''wvdi'',' str_win_demoguim ');'];
        cba_wpdi  = [mfilename '(''wpdi'',' str_win_demoguim ');'];
        cba_sw1d  = [mfilename '(''sw1d'',' str_win_demoguim ');'];
        cba_dens  = [mfilename '(''de1d'',' str_win_demoguim ');'];
        cba_regr  = [mfilename '(''re1d'',' str_win_demoguim ');'];
        cba_cf1d  = [mfilename '(''cf1d'',' str_win_demoguim ');'];
        cba_sw2d  = [mfilename '(''sw2d'',' str_win_demoguim ');'];
        cba_cf2d  = [mfilename '(''cf2d'',' str_win_demoguim ');'];
        cba_sext  = [mfilename '(''sext'',' str_win_demoguim ');'];
        cba_iext  = [mfilename '(''iext'',' str_win_demoguim ');'];
        cba_close = [mfilename '(''close'',' str_win_demoguim ');'];

        % Construction of objects.
        %-------------------------
        fra_Color  = get(win_demoguim,'Color');
        txt_Color  = fra_Color;
        commonProp = {'Parent',win_demoguim,'Unit',win_units };
        comFraProp = {commonProp{:}, ...
           'BackGroundColor',fra_Color,'Style','frame'};
        comPusProp = {commonProp{:},'Style','Pushbutton'};
        comTxtProp = {commonProp{:},'BackGroundColor',txt_Color,'Style','Text'};

        fra1 = uicontrol(comFraProp{:},'Position',pos_fra1);
        fra2 = uicontrol(comFraProp{:},'Position',pos_fra2);
        fra3 = uicontrol(comFraProp{:},'Position',pos_fra3);
        fra4 = uicontrol(comFraProp{:},'Position',pos_fra4);
        fra5 = uicontrol(comFraProp{:},'Position',pos_fra5);
        fra6 = uicontrol(comFraProp{:},'Position',pos_fra6);

        txt_fra1 = uicontrol(comTxtProp{:},'Position',pos_txt1,...
                             	'String',str_fra1);
        txt_fra2 = uicontrol(comTxtProp{:},'Position',pos_txt2,...
                             	'String',str_fra2);
        txt_fra3 = uicontrol(comTxtProp{:},'Position',pos_txt3,...
                             	'String',str_fra3);
        txt_fra4 = uicontrol(comTxtProp{:},'Position',pos_txt4,...
                             	'String',str_fra4);
        txt_fra5 = uicontrol(comTxtProp{:},'Position',pos_txt5,...
                             	'String',str_fra5);
        txt_fra6 = uicontrol(comTxtProp{:},'Position',pos_txt6,...
                             	'String',str_fra6);

        pus_dw1d = uicontrol(comPusProp{:}, ...
                             'Position',pos_dw1d,...
                             'String',str_dw1d,...
                             'Callback',cba_dw1d...
                             );
        pus_wp1d = uicontrol(comPusProp{:}, ...
                             'Position',pos_wp1d,...
                             'String',str_wp1d,...
                             'Callback',cba_wp1d...
                             );
        pus_cw1d = uicontrol(comPusProp{:}, ...
                             'Position',pos_cw1d,...
                             'String',str_cw1d,...
                             'Callback',cba_cw1d...
                             );
        pus_cwim = uicontrol(comPusProp{:}, ...
                             'Position',pos_cwim,...
                             'String',str_cwim,...
                             'Callback',cba_cwim...
                             );
        pus_dw2d = uicontrol(comPusProp{:}, ...
                             'Position',pos_dw2d,...
                             'String',str_dw2d,...
                             'Callback',cba_dw2d...
                             );
        pus_wp2d = uicontrol(comPusProp{:}, ...
                             'Position',pos_wp2d,...
                             'String',str_wp2d,...
                             'Callback',cba_wp2d...
                             );

        pus_wvdi = uicontrol(comPusProp{:}, ...
                             'Position',pos_wvdi,...
                             'String',str_wvdi,...
                             'Callback',cba_wvdi...
                             );
        pus_wpdi = uicontrol(comPusProp{:}, ...
                             'Position',pos_wpdi,...
                             'String',str_wpdi,...
                             'Callback',cba_wpdi...
                             );
			     
        pus_sw1d = uicontrol(comPusProp{:}, ...
                             'Position',pos_sw1d,...
                             'String',str_sw1d,...
                             'Callback',cba_sw1d...
                             );
        pus_dens = uicontrol(comPusProp{:}, ...
                             'Position',pos_dens,...
                             'String',str_dens,...
                             'Callback',cba_dens...
                             );
        pus_regr = uicontrol(comPusProp{:}, ...
                             'Position',pos_regr,...
                             'String',str_regr,...
                             'Callback',cba_regr...
                             );
        pus_cf1d = uicontrol(comPusProp{:}, ...
                             'Position',pos_cf1d,...
                             'String',str_cf1d,...
                             'Callback',cba_cf1d...
                             );			     
        pus_sw2d = uicontrol(comPusProp{:}, ...
                             'Position',pos_sw2d,...
                             'String',str_sw2d,...
                             'Callback',cba_sw2d...
                             );
        pus_cf2d = uicontrol(comPusProp{:}, ...
                             'Position',pos_cf2d,...
                             'String',str_cf2d,...
                             'Callback',cba_cf2d...
                             );
        pus_sext = uicontrol(comPusProp{:}, ...
                             'Position',pos_sext,...
                             'String',str_sext,...
                             'Callback',cba_sext...
                             );
        pus_iext = uicontrol(comPusProp{:}, ...
                             'Position',pos_iext,...
                             'String',str_iext,...
                             'Callback',cba_iext...
                             );
        pus_close = uicontrol(comPusProp{:}, ...
                              'Position',pos_close,...
                              'String',str_close,...
                              'Callback',cba_close,...
                              'Tag',tag_btn_close...
                              );

        % Prevent OS closing.
        %--------------------
        set(win_demoguim,'CloseRequestFcn',cba_close)

        % Setting units to normalized.
        %-----------------------------
        set(findobj(win_demoguim,'Units','pixels'),'Units','Normalized');

        % Hide figure handle.
        %--------------------   
        hidegui(win_demoguim,'off');

        % End waiting.
        %---------------
        mousefrm(0,'arrow');
        drawnow

    case {'dw1d','wp1d','cw1d','cwim','dw2d','wp2d','wvdi','wpdi',...
          'sw1d','de1d','re1d','cf1d','sw2d','cf2d','sext','iext'}
        %***********************************%
        %** OPTION = 'dw1d' -  demo DW1D  **%
        %** OPTION = 'wp1d' -  demo WP1D  **%
        %** OPTION = 'cw1d' -  demo CW1D  **%
        %** OPTION = 'cwim' -  demo CWIM  **%
        %** OPTION = 'dw2d' -  demo DW2D  **%
        %** OPTION = 'wp2d' -  demo WP2D  **%
        %** OPTION = 'wvdi' -  demo WVDI  **%       
        %** OPTION = 'wpdi' -  demo WPDI  **%
        %** OPTION = 'sw1d' -  demo SW1D  **%
        %** OPTION = 'de1d' -  demo DE1D  **%
        %** OPTION = 're1d' -  demo RE1D  **%
        %** OPTION = 'cf1d' -  demo CF1D  **%
        %** OPTION = 'sw2d' -  demo SW2D  **%
        %** OPTION = 'cf2d' -  demo CF2D  **%
        %** OPTION = 'sext' -  demo SEXT  **%
        %** OPTION = 'iext' -  demo IEXT  **%
        %***********************************%
        if nargin==1
            win = wfindobj('figure','tag',tag_guim_tool);
            wait_mode = 0;
        else
            win = in2;
            wait_mode = 1;
            if nargin==3 , wait_mode = in3; end
        end
        gui = wait_mode;
        demoname = ['dgui' option];
        ok_win =  ~isempty(win);
        if ok_win , demoguim('enable',win,'off'); end
        if ~isequal(gui,0)
            demomode = 'command';
            addclose = [mfilename '(''endshow'');'];
            wshowdrv(demoname,demomode,addclose);
        else
            if ok_win
                set(findobj(win,'tag',tag_btn_close),'enable','on');
            end
            feval(demoname,'noGUI',wait_mode);
            if ok_win , demoguim('enable',win,'on'); end
        end

    case 'enable'
        %*************************************************************%
        %** OPTION = 'enable' - Deseable or Enable demoguim window  **%
        %*************************************************************%
        % in2 = win handle
        % in3 = 'on' or 'off'   
        %--------------------
        if in3(1:2)=='of'
            mousefrm(0,'watch');
        else
            mousefrm(0,'arrow');
        end
        set(findobj(in2,'style','pushbutton'),'Enable',in3);
        drawnow;

    case 'auto'
        %**************************************************%
        %** OPTION = 'auto' - all demos (automatic mode) **%
        %**************************************************%
        clc
        demoguim('create');
        stop = 0;
        while stop==0
            demoguim('dw1d');
            demoguim('wp1d');
            demoguim('cw1d');
            demoguim('cwim');
            demoguim('dw2d');
            demoguim('wp2d');
            demoguim('wvdi');
            demoguim('wpdi');
            demoguim('sw1d');
            demoguim('de1d');
            demoguim('re1d');
            demoguim('cf1d');
            demoguim('sw2d');
            demoguim('cf2d');
            demoguim('sext');
            demoguim('iext');
            stop = 1;
            if nargin==2
                if strcmp(in2,'loop') , stop = 0 ; end
            end
        end
        win = wfindobj('figure','tag',tag_guim_tool);
        demoguim('close',win);

    case 'loop'
        %***********************************************************%
        %** OPTION = 'loop' - loop for all demos (automatic mode) **%
        %***********************************************************%
        demoguim('auto','loop');

    case 'endshow'
        %**************************************************%
        %** OPTION = 'endshow' - used to finish wshowdrv **%
        %**************************************************%
        win = wfindobj('figure','tag',tag_guim_tool);
        set(findobj(win,'style','pushbutton'),'Enable','on');
        drawnow;

    case 'startshow'
        %***************************************************%
        %** OPTION = 'startshow' - used to start wshowdrv **%
        %***************************************************%
        figNumber = in2;
        out1 = wmemtool('rmb',figNumber,'Activefig',1);
        if isempty(out1)
            out1 = feval(in3);
            hndlList  = get(figNumber,'Userdata');
            closeHndl = hndlList(7);
            callbackStr = get(closeHndl,'Callback');
            winact = int2str(out1);
            str1 = ['fig = find(get(0,''children'')==' winact ');'];
            str2 = ['if ~isempty(fig) , clear fig; ' ...
                in3 '(''close'',' winact '); delete(' winact '); end;'];
            cba_close = [str1,str2,callbackStr];
            set(closeHndl,'Callback',cba_close,'tag',tag_sub_close);
            set(figNumber,'CloseRequestFcn',cba_close);
        end

    case 'close'
        %***********************************************%
        %** OPTION = 'close' - close demoguim window  **%
        %***********************************************%
        mousefrm(0,'watch')

        % Closing all opened main analysis windows.
        %------------------------------------------
        pus_handles = wfindobj(0,'Style','pushbutton');
        hdls        = findobj(pus_handles,'flat','Tag',tag_sub_close);
        for i=1:length(hdls)
            hdl = hdls(i);
            err = 0;
            eval('par = get(hdl,''Parent'');','err = 1;')
            eval(get(hdl,'Callback'),'err = 1;');
            eval('delete(par)','err = 1;')
        end

        % Closing the demoguim window.
        %-----------------------------
        eval('delete(in2)','err = 1;');

        win_ini = wfindobj('figure','tag',tag_dem_tool);
        if ~isempty(win_ini)
            pus_handles = findobj(win_ini,'Style','pushbutton');
            set(pus_handles,'Enable','on');
        else
            mextglob('clear')
            wtbxmngr('clear')
        end
        mousefrm(0,'arrow');

    otherwise
        errargt(mfilename,'Unknown Option','msg');
        error('*');
end

% Reset the LASTERR function
lasterr('');

