function [out1,out2] = democmdm(option,in2,in3)
%DEMOCMDM Main command-line mode demos menu in the Wavelet Toolbox.
%   DEMOCMDM creates the window for command line mode demos.

%   DEMOCMDM('auto') shows all the command line mode demos
%   in automatic mode.
%
%   DEMOCMDM('loop') shows all the command line mode demos
%   in loop mode.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-Mar-96.
%   Last Revision: 27-Jun-1998.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.15 $ $Date: 2001/03/30 16:34:43 $

if nargin==0 , option = 'create'; end

tag_dem_tool  = 'Demo_Tool';
tag_cmdm_tool = 'Cmdm_Tool';
tag_btn_close = 'Demo_Close';
tag_sub_close = 'Cmdm_Close';

switch option
    case 'create'
        win = wfindobj('figure','tag',tag_cmdm_tool);
        if ~isempty(win) , return; end

        % Waiting Frame construction & begin waiting.
        %--------------------------------------------
        mousefrm(0,'watch');

        % CMDM main window initialization.
        %---------------------------------
        name = 'Command line mode demos';
        [win_democmdm,pos_win,defBtnWidth,defBtnHeight,win_units] = ...
                wdfigutl('menu',name,[13/4 41/2],tag_cmdm_tool);
        out1 = win_democmdm;
        str_win_democmdm = int2str(win_democmdm);

        % Position property of objects.
        %------------------------------
        btn_width  = 3*defBtnWidth;
        btn_heigth = 3*defBtnHeight/2;
        btn_left   = ceil(pos_win(3)-btn_width)/2;
        btn_low    = pos_win(4)-2*defBtnHeight;
        dif_heigth = 2*defBtnHeight;
        pos_dw1d   = [btn_left , btn_low , btn_width , btn_heigth];
        btn_low    = btn_low-dif_heigth;
        pos_cw1d   = [btn_left , btn_low , btn_width , btn_heigth];
        btn_low    = btn_low-dif_heigth;
        pos_dw2d   = [btn_left , btn_low , btn_width , btn_heigth];
        btn_low    = btn_low-dif_heigth;
        pos_comp   = [btn_left , btn_low , btn_width , btn_heigth];
        btn_low    = btn_low-dif_heigth;
        pos_deno   = [btn_left , btn_low , btn_width , btn_heigth];
        btn_low    = btn_low-dif_heigth;
        pos_wpck   = [btn_left , btn_low , btn_width , btn_heigth];
        btn_low    = btn_low-dif_heigth;
        pos_mala   = [btn_left , btn_low , btn_width , btn_heigth];
        btn_low    = btn_low-dif_heigth;
        pos_casc   = [btn_left , btn_low , btn_width , btn_heigth];
        btn_low    = btn_low-dif_heigth;
        pos_extm   = [btn_left , btn_low , btn_width , btn_heigth];
        btn_low    = btn_low-dif_heigth;
        pos_close  = [btn_left , btn_low , btn_width , btn_heigth];

        % String property of objects.
        %----------------------------
        str_dw1d   = 'Wavelet 1-D';
        str_cw1d   = 'Continuous Wavelet 1-D';
        str_dw2d   = 'Wavelet 2-D';
        str_comp   = 'Compression';
        str_deno   = 'De-noising';
        str_wpck   = 'Wavelet Packets';
        str_mala   = 'Mallat algorithm';
        str_casc   = 'Cascade algorithm';
        str_extm   = 'Border distortion';
        str_close  = 'Close';

        % Callback property of objects.
        %------------------------------
        cba_dw1d  = [mfilename '(''dw1d'',' str_win_democmdm ');'];
        cba_cw1d  = [mfilename '(''cw1d'',' str_win_democmdm ');'];
        cba_dw2d  = [mfilename '(''dw2d'',' str_win_democmdm ');'];
        cba_comp  = [mfilename '(''comp'',' str_win_democmdm ');'];
        cba_deno  = [mfilename '(''deno'',' str_win_democmdm ');'];
        cba_wpck  = [mfilename '(''wpck'',' str_win_democmdm ');'];
        cba_mala  = [mfilename '(''mala'',' str_win_democmdm ');'];
        cba_casc  = [mfilename '(''casc'',' str_win_democmdm ');'];
        cba_extm  = [mfilename '(''extm'',' str_win_democmdm ');'];
        cba_close = [mfilename '(''close'',' str_win_democmdm ');'];

        % Construction of objects.
        %-------------------------
        pus_dw1d   = uicontrol(...
                                   'Style','Pushbutton',...
                                   'Unit',win_units,...
                                   'Position',pos_dw1d,...
                                   'String',str_dw1d,...
                                   'Callback',cba_dw1d...
                                   );
        pus_cw1d   = uicontrol(...
                                   'Style','Pushbutton',...
                                   'Unit',win_units,...
                                   'Position',pos_cw1d,...
                                   'String',str_cw1d,...
                                   'Callback',cba_cw1d...
                                   );
        pus_dw2d   = uicontrol(...
                                   'Style','Pushbutton',...
                                   'Unit',win_units,...
                                   'Position',pos_dw2d,...
                                   'String',str_dw2d,...
                                   'Callback',cba_dw2d...
                                   );
        pus_comp   = uicontrol(...
                                   'Style','Pushbutton',...
                                   'Unit',win_units,...
                                   'Position',pos_comp,...
                                   'String',str_comp,...
                                   'Callback',cba_comp...
                                   );
        pus_deno   = uicontrol(...
                                   'Style','Pushbutton',...
                                   'Unit',win_units,...
                                   'Position',pos_deno,...
                                   'String',str_deno,...
                                   'Callback',cba_deno...
                                   );
        pus_wpck   = uicontrol(...
                                   'Style','Pushbutton',...
                                   'Unit',win_units,...
                                   'Position',pos_wpck,...
                                   'String',str_wpck,...
                                   'Callback',cba_wpck...
                                   );
        pus_mala   = uicontrol(...
                                   'Style','Pushbutton',...
                                   'Unit',win_units,...
                                   'Position',pos_mala,...
                                   'String',str_mala,...
                                   'Callback',cba_mala...
                                   );
        pus_casc   = uicontrol(...
                                   'Style','Pushbutton',...
                                   'Unit',win_units,...
                                   'Position',pos_casc,...
                                   'String',str_casc,...
                                   'Callback',cba_casc...
                                   );

        pus_extm   = uicontrol(...
                                   'Style','Pushbutton',...
                                   'Unit',win_units,...
                                   'Position',pos_extm,...
                                   'String',str_extm,...
                                   'Callback',cba_extm...
                                   );

        pus_close  = uicontrol(...
                                   'Style','Pushbutton',...
                                   'Unit',win_units,...
                                   'Position',pos_close,...
                                   'String',str_close,...
                                   'Callback',cba_close,...
                                   'Tag',tag_btn_close...
                                   );

        % Prevent OS closing.
        %--------------------
        set(win_democmdm,'CloseRequestFcn',cba_close)

        % Setting units to normalized.
        %-----------------------------
        set(findobj(win_democmdm,'Units','pixels'),'Units','Normalized');

        % Hide figure handle.
        %-------------------
        hidegui(win_democmdm,'off');

        % End waiting.
        %---------------
        mousefrm(0,'arrow');
        drawnow

    case {'dw1d','cw1d','dw2d','comp','deno','wpck','mala','casc','extm'}
        %*****************************************************%
        %** OPTION = 'dw1d' -  demo DW1D                    **%
        %** OPTION = 'cw1d' -  demo CW1D                    **%
        %** OPTION = 'dw2d' -  demo DW2D                    **%
        %** OPTION = 'comp' -  demo Compression             **%
        %** OPTION = 'deno' -  demo De-noising              **%
        %** OPTION = 'wpck' -  demo for Wavelet packets     **%
        %** OPTION = 'mala' -  demo for Mallat algorithm    **%
        %** OPTION = 'casc' -  demo for Cascade algorithm   **%
        %** OPTION = 'extm' -  demo for Boundary distortion **%
        %*****************************************************%
        expo_flag = 0;
        switch nargin
            case 1
                win = wfindobj('figure','tag',tag_cmdm_tool);
                wait_mode = 0; gui = 0;

            case 2
                if isempty(in2) , expo_flag = 1; end
                win = in2; wait_mode = 1; gui = 1;

            otherwise
                win = in2; wait_mode = in3; gui = wait_mode;
        end
        demoname = ['dcmd' option];
        ok_win   =  ~isempty(win);
        if ok_win , democmdm('enable',win,'off'); end
        if ~isequal(gui,0)
            switch option
                case 'dw1d' , demomode = 'mix7';
                case 'cw1d' , demomode = 'mix6';
                case 'dw2d' , demomode = 'mix9';
                case 'comp' , demomode = 'mix9';
                case 'deno' , demomode = 'mix8';
                case 'wpck' , demomode = 'mix7';
                case 'mala' , demomode = 'mix6';
                case 'casc' , demomode = 'mix9';
                case 'extm' , demomode = 'mix5';
                otherwise   , demomode = 'manual';
            end
            addclose = [mfilename '(''endshow'');'];
            if expo_flag
                addclose = [addclose 'mextglob(''clear''); wtbxmngr(''clear'');'];
            else
                addclose = [mfilename '(''endshow'');'];
            end
            wshowdrv(demoname,demomode,addclose);
            mousefrm(0,'arrow');
        else
            feval(demoname,'noGUI',wait_mode);
            if ok_win , democmdm('enable',win,'on'); end
        end

    case 'enable'
        %*************************************************************%
        %** OPTION = 'enable' - Deseable or Enable democmdm window  **%
        %*************************************************************%
        % in2 = win handle
        % in3 = 'on' or 'off'   
        %--------------------
        if in3(1:2)=='of'
            mousefrm(0,'watch');
        else
            mousefrm(0,'arrow');
        end
        set(findobj(in2,'style','pushbutton'),'Enable',in3);
        drawnow;

    case 'auto'
        %**************************************************%
        %** OPTION = 'auto' - all demos (automatic mode) **%
        %**************************************************%
        democmdm('create');
        stop = 0;
        while stop==0
            democmdm('dw1d');
            democmdm('cw1d');
            democmdm('dw2d');
            democmdm('comp');
            democmdm('deno');
            democmdm('wpck');
            democmdm('mala');
            democmdm('casc');
            democmdm('extm');
            stop = 1;
            if nargin==2 & strcmp(in2,'loop') , stop = 0 ; end
        end
        win = wfindobj('figure','tag',tag_cmdm_tool);
        democmdm('close',win);

    case 'loop'
        %************************************************************%
        %** OPTION = 'loop' - loop with all demos (automatic mode) **%
        %************************************************************%
        democmdm('auto','loop');

    case 'startshow'
        %***************************************************%
        %** OPTION = 'startshow' - used to start wshowdrv **%
        %***************************************************%
        % in2 = figNumber;
        % in3 = option
        hndlList  = get(in2,'UserData');
        closeHndl = hndlList(7);
        set(closeHndl,'tag',tag_sub_close);
        if strcmp(in3,'dw2d') | strcmp(in3,'casc')
           out1 = findobj(in2,'style','popupmenu');
           if isempty(out1)
              switch in3
                  case 'dw2d'
                        popstr = strvcat(...
                                        'woman2','sinsin','detfingr', ...
                                        'wbarb','detail','geometry', ...
                                        'tire','mandrill','woman',...
                                        'wifs','facets','tartan');
                        txtstr = 'Image';

                  case 'casc'
                        popstr = strvcat(...
                                        'sym4','sym8','db3','db5',...
                                        'db8','coif1','coif5');
                        txtstr = 'Wavelet';

              end
              autoHndl  = hndlList(5);
              pos = get(autoHndl,'Position');
              btnHt = 0.08; spacing = 0.04;
              pos(2) = pos(2)-spacing-btnHt/2;
              pos(4) = btnHt/2;
              t = uicontrol(in2,...
                          'style','text', ...
                          'Units','normalized', ...
                          'Position',pos, ...
                          'BackgroundColor',[0.5 0.5 0.5], ...
                          'String',txtstr);
              pos(2) = pos(2)-btnHt;
              pos(4) = btnHt;
              out1 = uicontrol(in2,...
                          'style','popupmenu', ...
                          'Units','normalized', ...
                          'Position',pos, ...
                          'String',popstr);
           end
       end

    case 'endshow'
        %**************************************************%
        %** OPTION = 'endshow' - used to finish wshowdrv **%
        %**************************************************%
        win = wfindobj('figure','tag',tag_cmdm_tool);
        set(findobj(win,'style','pushbutton'),'Enable','on');
        drawnow;

    case 'close'
        %***********************************************%
        %** OPTION = 'close' - close democmdm window  **%
        %***********************************************%
        mousefrm(0,'watch')
        if nargin==2
            win_democmdm = in2;
        else
            win_democmdm = wfindobj('figure','tag',tag_cmdm_tool);
        end

        % Closing all opened main analysis windows.
        %------------------------------------------
        pus_handles = wfindobj(0,'Style','pushbutton');
        hdls        = findobj(pus_handles,'flat','Tag',tag_sub_close);
        for i=1:length(hdls)
            hdl = hdls(i);
            try
              par = get(hdl,'Parent');
              try
                eval(get(hdl,'Callback'));
              end
              delete(par);
            end
        end

        % Closing the democmdm window.
        %-----------------------------
        try , delete(win_democmdm); end

        win_ini = wfindobj('figure','tag',tag_dem_tool);
        if ~isempty(win_ini)
            pus_handles = findobj(win_ini,'Style','pushbutton');
            set(pus_handles,'Enable','on');
        else
            mextglob('clear')
            wtbxmngr('clear')
        end
        mousefrm(0,'arrow');

    otherwise
        errargt(mfilename,'Unknown Option','msg');
        error('*');
end
