function dcmdwpck(varargin)
%DCMDWPCK Demonstrates wavelet packet tools in the Wavelet Toolbox. 

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-Mar-96.
%   Last Revision: 17-Jul-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
% $Revision: 1.12 $

% Check arguments.
%=================
switch nargin
  case 0 , figNumber = 0; wait_mode = 1;
  case 2 ,   
    if isequal(varargin{1},'noGUI')
        figNumber = 0;
        wait_mode = varargin{2};
    else
        figNumber = varargin{1};
        wait_mode = 1;
    end
end

if wshowdrv('init',figNumber)
    echo off
    clc;
    titre = 'Wavelet packets demo';
    if figNumber==0
        active_fig = wdfigutl('create',titre);
    else
        set(figNumber,'Name',titre);
        wshowdrv('setactfig',figNumber,figNumber);
        democmdm('startshow',figNumber,'wpck');
    end
    % Set axes.
    hdl_a = wshowdrv('set_axes',figNumber,[4 1]);
    if figNumber, return; end
else
    hdl_a = wshowdrv('get_axes',figNumber);
end
if figNumber , active_fig = wshowdrv('getactfig',figNumber); end

comment = str2mat( ...
              '% For wavelet packets analysis demos', ...
              '% see the GUI mode demos.', ...
              '% Let us give some examples of de-noising and compression', ...
              '% using wavelet packets.' ...
          );
wshowdrv('disp',figNumber,comment);

if wshowdrv('pause',figNumber,wait_mode), return; end;

comment = str2mat( ...
            '% Generate heavy sine and a noisy version of it.', ...
            ' ', ...
            '        init = 2055615866; randn(''seed'',init);', ...
            '        [xref,x] = wnoise(5,11,7,init);' ...
          );
wshowdrv('disp',figNumber,comment); 

% Generate heavy sine and a noisy version of it.
        init = 2055615866; randn('seed',init); 
        [xref,x] = wnoise(5,11,7,init);

% Plot signal and noisy signal.
        set(hdl_a(1),'Visible','on');axes(hdl_a(1));    
        plot(xref,'r'), title('Original signal')
        axis([1 length(xref) min(xref)-eps max(xref)+eps]);
        set(hdl_a(2),'Visible','on');axes(hdl_a(2));
        plot(x,'g'), title('Noisy Signal')
        axis([1 length(x) min(x)-eps max(x)+eps]);

if wshowdrv('pause',figNumber,wait_mode), return; end;

comment = str2mat( ...
            '% Use wpdencmp for signal de-noising.', ...
            ' ', ...
            '        n = length(x);', ...
            '        thr = sqrt(2*log(n*log(n)/log(2)));', ...
            '        xwpd = wpdencmp(x,''s'',4,''sym4'',''sure'',thr,1);' ...
          );
wshowdrv('disp',figNumber,comment); 

% Use wpdencmp for signal de-noising.
        n = length(x); thr = sqrt(2*log(n*log(n)/log(2)));
        xwpd = wpdencmp(x,'s',4,'sym4','sure',thr,1);

        set(hdl_a(3),'Visible','on');axes(hdl_a(3));
        plot(xwpd), title('Denoised Signal using Wavelet Packets')
        axis([1 length(xwpd) min(xwpd)-eps max(xwpd)+eps]);

if wshowdrv('pause',figNumber,wait_mode), return; end;

comment = str2mat( ...
              '% Compare with wavelets based denoising result.', ...
              ' ', ...
              '        xwd = wden(x,''rigrsure'',''s'',''one'',4,''sym4'');' ...
          );
wshowdrv('disp',figNumber,comment); 

% Compare with wavelets based denoising result.
        xwd = wden(x,'rigrsure','s','one',4,'sym4');

        set(hdl_a(4),'Visible','on');axes(hdl_a(4));
        plot(xwd), title('Denoised Signal using Wavelets')
        axis([1 length(xwd) min(xwd)-eps max(xwd)+eps]);

if wshowdrv('pause',figNumber,wait_mode), return; end;

comment = str2mat( ...
            'Zoom on the initial part of the signal,' , ...
            'the noisy signal and the two denoised signals.' ...
          );
wshowdrv('disp',figNumber,comment);
 
% set(hdl_a(1:4),'Xlim',[1 800]);

delete(hdl_a(3:4))
set([hdl_a(1:2)],'Xticklabel',[]);
figure(active_fig)
h3 = subplot(212);
ind = 1:800;
plot(ind,xwd(ind),'y',ind,xwpd(ind),'m')
title('Denoised Signals : Wavelet Packets (m) , Wavelets (y)')
set([hdl_a(1:2) h3],'Xlim',[1 800]);

if wshowdrv('pause',figNumber,wait_mode), return; end;

% Reset axes.
%------------
delete(findobj(active_fig,'type','axes'));

if figNumber
   subr = 1; subc = 2;
else
   subr = 2; subc = 1;
end

comment = str2mat( ...
            '        load detfingr ', ...
            '        % X contains the loaded image.', ...
            ' ', ...
            '        [r,c] = size(X);',   ...
            '        X = X(1:2:r,1:2:c);    % To reduce the size of X.' ...
          );
wshowdrv('disp',figNumber,comment); 

        load detfingr           % load image X
        [r,c] = size(X);
        X = X(1:2:r,1:2:c); 

% Plot original image.
	sm = size(map,1);
	figure(active_fig)
        colormap(pink(sm))
        subplot(subr,subc,1);
        image(wcodemat(X,sm)), title('Original Image')
	axis('square');

if wshowdrv('pause',figNumber,wait_mode), return; end;

comment = str2mat( ...
            '% Use wpdencmp for image compression.', ...
            '        sorh = ''h''; lev = 3;', ...
            '        crit = ''shannon'';', ...
            '        thr = 30;', ...
            '        keepapp = 1;', ...
            '        [xd,t,perf0,perfl2] = ... ', ...
            '                wpdencmp(X,sorh,lev,''bior6.8'',crit,thr,keepapp);' ...
          );
wshowdrv('disp',figNumber,comment); 

if wshowdrv('pause',figNumber,wait_mode), return; end;

% Use wpdencmp for image compression.
        lev =3; 
        sorh = 'h'; crit = 'shannon';
        thr = 30;   keepapp = 1;
        [xd,t,perf0,perfl2] = wpdencmp(X,sorh,lev,'bior6.8',crit,thr,keepapp);

% Plot compressed image.
	figure(active_fig)
        subplot(subr,subc,2);
        image(wcodemat(xd,sm)), title('Compressed Image')
%        xlabel(['norm cfs. rec.: ',num2str(perfl2,'%5.2f'),...
%                ' %  - nul cfs : ',num2str(perf0,'%5.2f'), ' %'])
	strxlab = strvcat(['norm cfs. rec.: ',num2str(perfl2,'%5.2f') ' %'],...
			['nul cfs : ',num2str(perf0,'%5.2f'), ' %']);
	xlabel(strxlab);

	axis('square');
        clear t d perf0 perfl2

if wshowdrv('pause',figNumber,wait_mode), return; end;

% Reset axes.
%------------
delete(findobj(active_fig,'type','axes'));

comment = str2mat( ...
            '% Load original image.', ...
            ' ', ...
            '        load  sinsin', ...
            '        % X contains the loaded image.', ...
            ' ', ...
            '        X = X(1:64,1:64); ' ...
          );
wshowdrv('disp',figNumber,comment); 

% Load original image.
        load  sinsin
        X = X(1:64,1:64); % zoom

	figure(active_fig)
        subplot(221), image(wcodemat(X,sm)), title('Original Image')

if wshowdrv('pause',figNumber,wait_mode), return; end;

        init = 2055615866; randn('seed',init);
        x = X+15*randn(size(X));

	figure(active_fig)
        subplot(222), image(wcodemat(x,sm)), title('Noisy Image')
        if wshowdrv('pause',figNumber,wait_mode), return; end;

        [thr,sorh,keepapp,crit] = ddencmp('den','wp',x);
        n  = length(x(:)); thr = sqrt(2*log(n*log(n)/log(2)))*15;
        xd = wpdencmp(x,sorh,3,'sym4',crit,thr,keepapp);

	figure(active_fig)
        subplot(223), image(wcodemat(xd,sm)), title('Denoised Image')

if figNumber==0
        wshowdrv('pause',figNumber,wait_mode);
        delete(active_fig);
end
