function dcmdextm(varargin)
%DCMDEXTM Demonstrates border distortions tools in the Wavelet Toolbox. 

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-Mar-96.
%   Last Revision: 27-Jul-2000.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.12 $  $Date: 2001/03/30 16:34:39 $

% Check arguments.
%=================
switch nargin
  case 0 , figNumber = 0; wait_mode = 1;
  case 2 ,   
    if isequal(varargin{1},'noGUI')
        figNumber = 0;
        wait_mode = varargin{2};
    else
        figNumber = varargin{1};
        wait_mode = 1;
    end
end

if wshowdrv('init',figNumber)
    echo off
    clc;
    titre = 'Border distortion';
    if figNumber==0
	active_fig = wdfigutl('create',titre);
    else
        set(figNumber,'Name',titre);
        wshowdrv('setactfig',figNumber,figNumber);
        democmdm('startshow',figNumber,'extm');
    end
    % Set axes.
    hdl_a = wshowdrv('set_axes',figNumber,[4 1]);
    if figNumber, return; end
else
    hdl_a = wshowdrv('get_axes',figNumber,[4 1]);
end
if figNumber , active_fig = wshowdrv('getactfig',figNumber); end

comment = str2mat( ...
            '% Load signal.', ...
            '        load nearbrk;', ...
            '        x = nearbrk;' ...
          );
wshowdrv('disp',figNumber,comment); 

% Load signal.
        load nearbrk; 
        x = nearbrk; clear nearbrk

len = length(x);
nbcol = 128;

figure(active_fig)
colormap(pink(nbcol));
set(hdl_a(1),'Visible','on');axes(hdl_a(1));    
plot(x,'r');
title('Original Signal : two near first derivative discontinuities');

if wshowdrv('pause',figNumber,wait_mode), return; end;

comment = str2mat( ...
            '% Set DWT signal extension mode to zero padding.', ...
            ' ', ...
            '        dwtmode(''zpd'')' ...
          );
wshowdrv('disp',figNumber,comment); 

% Set DWT signal extension mode to zero padding.
if figNumber
   dwtmode('zpd','silent');
else
   dwtmode('zpd');
end

if wshowdrv('pause',figNumber,wait_mode), return; end;

comment = str2mat( ...
            '% Perform decomposition at level 5', ...
            '% for the signal using db2 and', ...
            '% expand discrete wavelet coefficients for plot.', ...
            '        lev = 5;', ...
            '        [c,l] = wavedec(x,lev,''db2'');' ...
          );
wshowdrv('disp',figNumber,comment); 

% Perform decomposition at level 5
% for the signal using db2 and 
% expand discrete wavelet coefficients for plot.

        lev = 5;
        [c,l] = wavedec(x,lev,'db2');

cfd = zeros(lev,len);
for k = 1:lev
        d = detcoef(c,l,k);
        d = d(:)';
        d = d(ones(1,2^k),:);
        cfd(k,:) = wkeep(d(:)',len);
end
cfd =  cfd(:);
I = find(abs(cfd)<sqrt(eps));
cfd(I) = zeros(size(I));
cfd    = reshape(cfd,lev,len);
tics = 1:1:lev;
labs = 1:lev;
set(hdl_a(2),'Visible','on');axes(hdl_a(2));
image(wcodemat(cfd,nbcol));
title('Coefficients using zero padding');
set(hdl_a(2),                   ...
        'YTicklabelMode','manual',      ...
        'YTick',tics,                   ...
        'YTicklabel',labs,             ...
	'YDir','normal', 	    ...
        'Box','On'                      ...
        );
ylabel('level')

if wshowdrv('pause',figNumber,wait_mode), return; end;

comment = str2mat( ...
            '% Set DWT signal extension mode to symmetrization.', ...
            '        dwtmode(''sym'')', ...
            '% Perform the same two previous steps.', ...
            '        [c,l] = wavedec(x,lev,''db2'');' ...
          );
wshowdrv('disp',figNumber,comment); 

% Set DWT signal extension mode to symmetrization.
if figNumber
   dwtmode('sym','silent');
else
   dwtmode('sym');
end

% Perform the same two previous steps.
        [c,l] = wavedec(x,lev,'db2');

cfd = zeros(lev,len);
for k = 1:lev
        d = detcoef(c,l,k);
        d = d(:)';
        d = d(ones(1,2^k),:);
        cfd(k,:) = wkeep(d(:)',len);
end
cfd =  cfd(:);
I = find(abs(cfd)<sqrt(eps));
cfd(I) = zeros(size(I));
cfd    = reshape(cfd,lev,len);

set(hdl_a(3),'Visible','on');axes(hdl_a(3));
image(wcodemat(cfd,nbcol));
title('Coefficients using symmetrization padding');
set(hdl_a(3),                   ...
        'YTicklabelMode','manual',      ...
        'YTick',tics,                   ...
	'YTicklabel',labs,             ...
	'YDir','normal', 	    	...
	'Box','On'                      ...
	);
ylabel('level')

if wshowdrv('pause',figNumber,wait_mode), return; end;

comment = str2mat( ...
            '% Set DWT signal extension mode to smooth padding.', ...
            '        dwtmode(''spd'')', ...
            '% Perform the same two previous steps.', ...
            '        [c,l] = wavedec(x,lev,''db2'');' ...
          );
wshowdrv('disp',figNumber,comment); 

% Set DWT signal extension mode to smooth padding.
if figNumber
   dwtmode('spd','silent');
else
   dwtmode('spd');
end

% Perform the same two previous steps.
        [c,l] = wavedec(x,lev,'db2');

echo off
cfd = zeros(lev,len);
for k = 1:lev
        d = detcoef(c,l,k);
        d = d(:)';
        d = d(ones(1,2^k),:);
        cfd(k,:) = wkeep(d(:)',len);
end
cfd =  cfd(:);
I = find(abs(cfd)<sqrt(eps));
cfd(I) = zeros(size(I));
cfd    = reshape(cfd,lev,len);

set(hdl_a(4),'Visible','on');axes(hdl_a(4));
image(wcodemat(cfd,nbcol));
title('Coefficients using smooth padding');
set(hdl_a(4), ...
        'YTicklabelMode','manual',      ...
        'YTick',tics,                   ...
	'YTicklabel',labs,             ...
	'YDir','normal', 	    	...
        'Box','On'                      ...
        );
ylabel('level')

if wshowdrv('pause',figNumber,wait_mode), return; end;

comment = str2mat( ...
            '% Change colormap.', ...
            ' ', ...
            '        colormap(cool(2))' ...
          );
wshowdrv('disp',figNumber,comment); 

% Change colormap.
        colormap(cool(2))

if wshowdrv('pause',figNumber,wait_mode), return; end;

% Reset axes.
%------------
delete(findobj(active_fig,'type','axes'));

comment = str2mat( ...
            '% Load artificial image.', ...
            '        load geometry;' , ...
            ' % Set DWT signal extension mode to zero padding.', ...
            '        dwtmode(''zpd'')' ...
          );
wshowdrv('disp',figNumber,comment); 

% Load artificial image.
        load geometry; 

sX = size(X);
row = sX(1); col = sX(2);
nbcol = size(map,1);
figure(active_fig)
colormap(pink(nbcol));
subplot(221); image(wcodemat(X,nbcol));
title('Original image');

% Set DWT signal extension mode to zero padding.
if figNumber
   dwtmode('zpd','silent');
else
   dwtmode('zpd');
end

if wshowdrv('pause',figNumber,wait_mode), return; end;

comment = str2mat( ...
            '% Perform decomposition at level 3', ...
            '% of X using sym4, and reconstruct', ...
            '% approximation of level 3.', ...
            '        lev = 3; [c,s] = wavedec2(X,lev,''sym4'');', ...
            '        a = wrcoef2(''a'',c,s,''sym4'',lev);' ...
          );
wshowdrv('disp',figNumber,comment); 

% Perform decomposition at level 3
% of X using sym4, and reconstruct 
% approximation of level 3.
        lev = 3; [c,s] = wavedec2(X,lev,'sym4');
        a = wrcoef2('a',c,s,'sym4',lev);

figure(active_fig)
subplot(222); image(wcodemat(a,nbcol));
title('app. 3 using zero padding');

if wshowdrv('pause',figNumber,wait_mode), return; end;

comment = str2mat( ...
            '% Set DWT signal extension mode to symmetrization.', ...
            '        dwtmode(''sym'')', ...
            '% Perform the same two previous steps.', ...
            '        [c,s] = wavedec2(X,lev,''sym4'');', ...
            '        a = wrcoef2(''a'',c,s,''sym4'',lev);' ...
          );
wshowdrv('disp',figNumber,comment); 

% Set DWT signal extension mode to symmetrization.
if figNumber
   dwtmode('sym','silent');
else
   dwtmode('sym');
end

% Perform the same two previous steps.
        [c,s] = wavedec2(X,lev,'sym4');
        a = wrcoef2('a',c,s,'sym4',lev);

figure(active_fig)
subplot(223); image(wcodemat(a,nbcol));
title('app. 3 using symmetrization padding');

if wshowdrv('pause',figNumber,wait_mode), return; end;

comment = str2mat( ...
            '% Set DWT signal extension mode to smooth padding.', ...
            '        dwtmode(''spd'')', ...
            '% Perform the same two previous steps.', ...
            '        [c,s] = wavedec2(X,lev,''sym4'');', ...
            '        a = wrcoef2(''a'',c,s,''sym4'',lev);' ...
          );
wshowdrv('disp',figNumber,comment); 

% Set DWT signal extension mode to smooth padding.
if figNumber
   dwtmode('spd','silent');
else
   dwtmode('spd');
end

% Perform the same two previous steps.
        [c,s] = wavedec2(X,lev,'sym4');
        a = wrcoef2('a',c,s,'sym4',lev);

figure(active_fig)
subplot(224); image(wcodemat(a,nbcol));
title('app. 3 using smooth padding');

if figNumber==0
        wshowdrv('pause',figNumber,wait_mode);
        delete(active_fig);
end

