function dcmddw2d(varargin)
%DCMDDW2D Demonstrates discrete 2-D wavelet tools in the Wavelet Toolbox. 

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-Mar-96.
%   Last Revision: 27-Jun-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
% $Revision: 1.13 $

% Check arguments.
%=================
switch nargin
  case 0 , figNumber = 0; wait_mode = 1;
  case 2 ,   
    if isequal(varargin{1},'noGUI')
        figNumber = 0;
        wait_mode = varargin{2};
    else
        figNumber = varargin{1};
        wait_mode = 1;
    end
end

if wshowdrv('init',figNumber)
    echo off
    clc;
    titre = 'Orthogonal Wavelets 2-D';
    if figNumber==0
	active_fig = wdfigutl('create',titre);
        pop = -1;
    else
        set(figNumber,'Name',titre);
        wshowdrv('setactfig',figNumber,figNumber);
        democmdm('startshow',figNumber,'dw2d');
        return;
    end
end
if figNumber , active_fig = wshowdrv('getactfig',figNumber); end

if figNumber
   pop = democmdm('startshow',figNumber,'dw2d');
   v = get(pop,'value');
   s = get(pop,'string');
   if ishandle(pop), set(pop,'Enable','off'); end
   imgname = s(v,:);
else
   imgname = 'woman2';
end

comment = str2mat( ...
                '% Load original image.', ...
                ['        load ' imgname], ...
                '        % X is the loaded image.', ...
                '        % and map the loaded colormap.', ...
                ' ', ...
                '% Image coding.', ...
                '        nbcol = size(map,1);', ...
                '        cod_X = wcodemat(X,nbcol);' ...
                );
wshowdrv('disp',figNumber,comment);

% Load original image.
        eval(['load ' imgname])

        if figNumber
           imgname = deblankl(imgname);
           [r,c] = size(X);
           if strcmp(imgname,'detail')
              c = r;
              X = X(1:2:r,1:2:c);
           elseif strcmp(imgname,'mandrill')
              X = X(1:4:r,1:5:c);
           elseif strcmp(imgname,'tire')
              X = X(1:204,:);
           elseif strcmp(imgname,'detfingr')
              r = 296; c = 296;
              X = X(1:2:r,1:2:c);
           elseif strcmp(imgname,'durer')
              r = 640;
              X = X(1:4:r,1:4:c);
           elseif strcmp(imgname,'wifs')

           end
           [r,c] = size(X);
           if rem(r,4)>0 | rem(c,4)>0
              X = X(1:r-rem(r,4),1:c-rem(c,4));
           end
        end

        sX = size(X);
        row = sX(1); col = sX(2);

% Image coding.
        nbcol = size(map,1);
        cod_X = wcodemat(X,nbcol);      

if figNumber
   subr = 1; subc = 2;
else
   subr = 2; subc = 1;
end

figure(active_fig)
colormap(pink(nbcol));
subplot(subr,subc,1);
image(cod_X); axis('square');
title('Original image X.');

if wshowdrv('pause',figNumber,wait_mode)
	if ishandle(pop), set(pop,'Enable','on'); end
	return;
end;

comment = str2mat( ...
                '% Perform one step decomposition.', ...
                '        [ca1,ch1,cv1,cd1] = dwt2(X,''db1'');', ...
                ' ', ...
                '% Image coding.', ...
                '        cod_ca1 = wcodemat(ca1,nbcol);', ...
                '        cod_ch1 = wcodemat(ch1,nbcol);', ...
                '        cod_cv1 = wcodemat(cv1,nbcol);', ...
                '        cod_cd1 = wcodemat(cd1,nbcol);', ...
                '        image([cod_ca1,cod_ch1;cod_cv1,cod_cd1]);' ...
                );
wshowdrv('disp',figNumber,comment);

% Perform one step decomposition
% of X using db1.
        [ca1,ch1,cv1,cd1] = dwt2(X,'db1');

% Images coding.
        cod_ca1 = wcodemat(ca1,nbcol);
        cod_ch1 = wcodemat(ch1,nbcol);
        cod_cv1 = wcodemat(cv1,nbcol);
        cod_cd1 = wcodemat(cd1,nbcol);
        dec2d = [...
                cod_ca1,       cod_ch1;       ...
                cod_cv1,       cod_cd1        ...
                ];

clear dec2d
figure(active_fig)
ax = subplot(subr,subc,2);
image([cod_ca1,cod_ch1;cod_cv1,cod_cd1]); axis('square');
line('Xdata',[1 col],'Ydata',[row/2 row/2]);
line('Xdata',[col/2 col/2],'Ydata',[1 row]);
title('Decomposition at level 1');
% set(ax,'XTickLabel','','YTickLabel','');

if wshowdrv('pause',figNumber,wait_mode)
	if ishandle(pop), set(pop,'Enable','on'); end
	return;
end;

% Visualize the coefficients of the decomposition.

nul = zeros(size(cod_ca1));
figure(active_fig)
subplot(subr,subc,2);
image([cod_ca1,nul;nul,nul]); axis('square');
line('Xdata',[1 col],'Ydata',[row/2 row/2]);
line('Xdata',[col/2 col/2],'Ydata',[1 row]);
title('Coef. of Approximation at level 1');
% set(ax,'XTickLabel','','YTickLabel','');

if wshowdrv('pause',figNumber,wait_mode)
	if ishandle(pop), set(pop,'Enable','on'); end
	return;
end;

clc;
figure(active_fig)
subplot(subr,subc,2);
image([nul,cod_ch1;nul,nul]); axis('square');
line('Xdata',[1 col],'Ydata',[row/2 row/2]);
line('Xdata',[col/2 col/2],'Ydata',[1 row]);
title('Coef. of Horizontal Detail at level 1');
% set(ax,'XTickLabel','','YTickLabel','');

if wshowdrv('pause',figNumber,wait_mode)
	if ishandle(pop), set(pop,'Enable','on'); end
	return;
end;

clc;
figure(active_fig)
subplot(subr,subc,2);
image([nul,nul;cod_cv1,nul]); axis('square');
line('Xdata',[1 col],'Ydata',[row/2 row/2]);
line('Xdata',[col/2 col/2],'Ydata',[1 row]);
title('Coef. of Vertical Detail at level 1');
% set(ax,'XTickLabel','','YTickLabel','');

if wshowdrv('pause',figNumber,wait_mode)
	if ishandle(pop), set(pop,'Enable','on'); end
	return;
end;

figure(active_fig)
subplot(subr,subc,2);
image([nul,nul;nul,cod_cd1]); axis('square');
line('Xdata',[1 col],'Ydata',[row/2 row/2]);
line('Xdata',[col/2 col/2],'Ydata',[1 row]);
title('Coef. of Diagonal Detail at level 1');
% set(ax,'XTickLabel','','YTickLabel','');

if wshowdrv('pause',figNumber,wait_mode)
	if ishandle(pop), set(pop,'Enable','on'); end
	return;
end;

figure(active_fig)
subplot(subr,subc,2);
image([cod_ca1,cod_ch1;cod_cv1,cod_cd1]); axis('square');
line('Xdata',[1 col],'Ydata',[row/2 row/2]);
line('Xdata',[col/2 col/2],'Ydata',[1 row]);
title('Decomposition at level 1');
% set(ax,'XTickLabel','','YTickLabel','');
clear nul

if wshowdrv('pause',figNumber,wait_mode)
	if ishandle(pop), set(pop,'Enable','on'); end
	return;
end;

comment = str2mat( ...
                '% Perform second step decomposition :', ...
                '% decompose approx. cfs of level 1.', ...
                '        [ca2,ch2,cv2,cd2] = dwt2(ca1,''db1'');', ...
                ' ' , ...
                '% Code ca2, ch2,cv2 and cd2.', ...
                '        cod_ca2 = wcodemat(ca2,nbcol);', ...
                '        cod_ch2 = wcodemat(ch2,nbcol);', ...
                '        cod_cv2 = wcodemat(cv2,nbcol);', ...
                '        cod_cd2 = wcodemat(cd2,nbcol);'  ...
                );
wshowdrv('disp',figNumber,comment);

% Perform second step decomposition :
% decompose approx. cfs of level 1.
        [ca2,ch2,cv2,cd2] = dwt2(ca1,'db1');

% Image coding.
        cod_ca2 = wcodemat(ca2,nbcol);        clear ca2
        cod_ch2 = wcodemat(ch2,nbcol);        clear ch2
        cod_cv2 = wcodemat(cv2,nbcol);        clear cv2
        cod_cd2 = wcodemat(cd2,nbcol);        clear cd2

        cod_ca1 = [cod_ca2,cod_ch2;cod_cv2,cod_cd2];
        clear cod_ca2 cod_ch2 cod_cv2 cod_cd2

figure(active_fig)
subplot(subr,subc,2);
image([cod_ca1,cod_ch1;cod_cv1,cod_cd1]); axis('square');
line('Xdata',[1 col/2],'Ydata',[row/4 row/4]);
line('Xdata',[col/4 col/4],'Ydata',[1 row/2]);
line('Xdata',[1 col],'Ydata',[row/2 row/2]);
line('Xdata',[col/2 col/2],'Ydata',[1 row]);
title('Decomposition at level 2');
% set(ax,'XTickLabel','','YTickLabel','');

if wshowdrv('pause',figNumber,wait_mode)
	if ishandle(pop), set(pop,'Enable','on'); end
	return;
end;

% Reset axes.
%------------
delete(findobj(active_fig,'type','axes'));

comment = str2mat( ...
                '% Zoom the decomposition at level 2.' ...   
                );
wshowdrv('disp',figNumber,comment);

figure(active_fig)
image([cod_ca1,cod_ch1;cod_cv1,cod_cd1]); axis('square');
line('Xdata',[1 col/2],'Ydata',[row/4 row/4]);
line('Xdata',[col/4 col/4],'Ydata',[1 row/2]);
line('Xdata',[1 col],'Ydata',[row/2 row/2]);
line('Xdata',[col/2 col/2],'Ydata',[1 row]);
title('Decomposition at level 2');
% set(ax,'XTickLabel','','YTickLabel','');

if wshowdrv('pause',figNumber,wait_mode)
	if ishandle(pop), set(pop,'Enable','on'); end
	return;
end;

% Reset axes.
%------------
delete(findobj(active_fig,'type','axes'));

if figNumber
   subr = 1; subc = 3;
else
   subr = 3; subc = 1;
end

comment = str2mat( ...
                '% Invert directly decomposition of X' , ...
                '% using coefficients at level 1.' , ...
                ' ', ...
                '        a0 = idwt2(ca1,ch1,cv1,cd1,''db1'',size(X));' , ...
                ' '  ...
                );
wshowdrv('disp',figNumber,comment);

figure(active_fig)
h1 = subplot(subr,subc,1); image(cod_X);
axis('square');
title('Original image X.');
set(h1,'Xtick',[],'Xticklabel',[],...
       'Ytick',[],'Yticklabel',[]);
drawnow;

cod_ca1  = wcodemat(ca1,nbcol);
figure(active_fig)
h3 = subplot(subr,subc,3);
image([cod_ca1,cod_ch1;cod_cv1,cod_cd1]);
axis('square');
set(h3,'Xtick',[],'Xticklabel',[],...
       'Ytick',[],'Yticklabel',[]);
clear cod_ca1 cod_ch1 cod_cv1 cod_cd1
line('Xdata',[1 col],'Ydata',[row/2 row/2]);
line('Xdata',[col/2 col/2],'Ydata',[1 row]);
title('Decomp. at level 1');

% Invert directly decomposition of X
% using coefficients at level 1.
        a0 = idwt2(ca1,ch1,cv1,cd1,'db1',sX);

figure(active_fig)
h2 = subplot(subr,subc,2); image(wcodemat(a0,nbcol));
axis('square');
set(h2,'Xtick',[],'Xticklabel',[],...
       'Ytick',[],'Yticklabel',[]);
title('Recons. image : a0.');

if wshowdrv('pause',figNumber,wait_mode)
	if ishandle(pop), set(pop,'Enable','on'); end
	return;
end;

% Reset axes.
%------------
delete(findobj(active_fig,'type','axes'));

comment = str2mat( ...
            '% Perform decomposition at level 2', ...
            '% of X using db1.', ...
            ' ', ...
            '        [c,s] = wavedec2(X,2,''db1'');' ...
                );
wshowdrv('disp',figNumber,comment);

figure(active_fig)
h1 = subplot(subr,subc,1); image(cod_X);
axis('square');
set(h1,'Xtick',[],'Xticklabel',[],...
       'Ytick',[],'Yticklabel',[]);
title('Original image X.');
drawnow;

% Perform decomposition at level 2
% of X using db1.
        [c,s] = wavedec2(X,2,'db1');

if wshowdrv('pause',figNumber,wait_mode)
	if ishandle(pop), set(pop,'Enable','on'); end
	return;
end;

comment = str2mat( ...
            '% Extract coefficients at level 2,', ...
            '% from wavelet decomposition structure [c,s].', ...
            ' ', ...
            '        ca2 = appcoef2(c,s,''db1'',2);', ...
            '        ch2 = detcoef2(''h'',c,s,2);', ...
            '        cv2 = detcoef2(''v'',c,s,2);', ...
            '        cd2 = detcoef2(''d'',c,s,2);' ...
                );
wshowdrv('disp',figNumber,comment);

% Extract coefficients at level 2,
% from wavelet decomposition structure [c,s].

        ca2 = appcoef2(c,s,'db1',2);
        ch2 = detcoef2('h',c,s,2);
        cv2 = detcoef2('v',c,s,2);
        cd2 = detcoef2('d',c,s,2);

% Image coding.
        cod_ca2 = wcodemat(ca2,nbcol); clear ca2
        cod_ch2 = wcodemat(ch2,nbcol); clear ch2
        cod_cv2 = wcodemat(cv2,nbcol); clear cv2
        cod_cd2 = wcodemat(cd2,nbcol); clear cd2
 
cod_ca1 = [cod_ca2,cod_ch2;cod_cv2,cod_cd2];

clear cod_ca2 cod_ch2 cod_cv2 cod_cd2
 
nul = zeros(size(cod_ca1));

figure(active_fig)
h2 = subplot(subr,subc,2); image([cod_ca1,nul;nul,nul]);
axis('square');
set(h2,'Xtick',[],'Xticklabel',[],...
       'Ytick',[],'Yticklabel',[]);
clear nul
line('Xdata',[1 col/2],'Ydata',[row/4 row/4]);
line('Xdata',[col/4 col/4],'Ydata',[1 row/2]);
line('Xdata',[1 col],'Ydata',[row/2 row/2]);
line('Xdata',[col/2 col/2],'Ydata',[1 row]);
title('Coef. at level 2.');

if wshowdrv('pause',figNumber,wait_mode)
	if ishandle(pop), set(pop,'Enable','on'); end
	return;
end;

comment = str2mat( ...
            '% Extract coefficients at level 1,', ...
            '% from wavelet decomposition structure [c,s].', ...
            ' ', ...
            '        ca1 = appcoef2(c,s,''db1'',1);', ...
            '        ch1 = detcoef2(''h'',c,s,1);', ...
            '        cv1 = detcoef2(''v'',c,s,1);', ...
            '        cd1 = detcoef2(''d'',c,s,1);' ...
                );
wshowdrv('disp',figNumber,comment);

% Extract approximation and details coefficients
% at level 1, from wavelet decomposition
% structure [c,s].
        ca1 = appcoef2(c,s,'db1',1);
        ch1 = detcoef2('h',c,s,1);
        cv1 = detcoef2('v',c,s,1);
        cd1 = detcoef2('d',c,s,1);

% Image coding.
        cod_ca1 = wcodemat(ca1,nbcol);       clear ca1
        cod_ch1 = wcodemat(ch1,nbcol);       clear ch1
        cod_cv1 = wcodemat(cv1,nbcol);       clear cv1
        cod_cd1 = wcodemat(cd1,nbcol);       clear cd1

figure(active_fig)
h3 = subplot(subr,subc,3); image([cod_ca1,cod_ch1;cod_cv1,cod_cd1]);
axis('square');
set(h3,'Xtick',[],'Xticklabel',[],...
       'Ytick',[],'Yticklabel',[]);
clear cod_ca1 cod_ch1 cod_cv1 cod_cd1
line('Xdata',[1 col],'Ydata',[row/2 row/2]);
line('Xdata',[col/2 col/2],'Ydata',[1 row]);
title('Coef. at level 1.');

if wshowdrv('pause',figNumber,wait_mode)
	if ishandle(pop), set(pop,'Enable','on'); end
	return;
end;

% Reset axes.
%------------
delete(findobj(active_fig,'type','axes'));

figure(active_fig)
ax = subplot(341); image(cod_X); axis('square');
title('X');
set(ax,'Xtick',[],'Xticklabel',[],...
       'Ytick',[],'Yticklabel',[]);
drawnow;

if wshowdrv('pause',figNumber,wait_mode)
	if ishandle(pop), set(pop,'Enable','on'); end
	return;
end;

comment = str2mat( ...
            '% Reconstruct approximation at level 2,', ...
            '% from the wavelet decomposition', ...
            '% structure [c,s].', ...
            ' ', ...
            '        a2 = wrcoef2(''a'',c,s,''db1'',2);' ...
                );
wshowdrv('disp',figNumber,comment);

% Reconstruct approximation at level 2,
% from the wavelet decomposition
% structure [c,s].
        a2 = wrcoef2('a',c,s,'db1',2);

figure(active_fig)
ax = subplot(3,4,9); image(wcodemat(a2,nbcol)); axis('square');
title('a2')
set(ax,'Xtick',[],'Xticklabel',[],...
       'Ytick',[],'Yticklabel',[]);
clear a2

if wshowdrv('pause',figNumber,wait_mode)
	if ishandle(pop), set(pop,'Enable','on'); end
	return;
end;

comment = str2mat( ...
            '% Reconstruct detail at level 2,', ...
            '% from the wavelet decomposition', ...
            '% structure [c,s].', ...
            '        h2 = wrcoef2(''h'',c,s,''db1'',2);', ...
            '        v2 = wrcoef2(''v'',c,s,''db1'',2);', ...
            '        d2 = wrcoef2(''d'',c,s,''db1'',2);' ...
                );
wshowdrv('disp',figNumber,comment);

% Reconstruct details at level 2,
% from the wavelet decomposition
% structure [c,s].
        h2 = wrcoef2('h',c,s,'db1',2);
        v2 = wrcoef2('v',c,s,'db1',2);
	d2 = wrcoef2('d',c,s,'db1',2);

figure(active_fig)
ax = subplot(3,4,10); image(wcodemat(h2,nbcol)); axis('square');
title('h2');
set(ax,'Xtick',[],'Xticklabel',[],...
       'Ytick',[],'Yticklabel',[]);
clear h2

figure(active_fig)
ax = subplot(3,4,11); image(wcodemat(v2,nbcol)); axis('square');
title('v2');
set(ax,'Xtick',[],'Xticklabel',[],...
       'Ytick',[],'Yticklabel',[]);
clear v2

figure(active_fig)
ax = subplot(3,4,12); image(wcodemat(d2,nbcol)); axis('square');
title('d2');
set(ax,'Xtick',[],'Xticklabel',[],...
       'Ytick',[],'Yticklabel',[]);
clear d2

if wshowdrv('pause',figNumber,wait_mode)
	if ishandle(pop), set(pop,'Enable','on'); end
	return;
end;

comment = str2mat( ...
            '% One step reconstruction of wavelet', ...
            '% decomposition structure [c,s].', ...
            '        [c,s] = upwlev2(c,s,''db1'');' ...
                );
wshowdrv('disp',figNumber,comment);

% One step reconstruction of wavelet
% decomposition structure [c,s].
        sc = size(c);
        val_s = s; 
        [c,s] = upwlev2(c,s,'db1');;
        sc = size(c);
        val_s = s;

if wshowdrv('pause',figNumber,wait_mode)
	if ishandle(pop), set(pop,'Enable','on'); end
	return;
end;

comment = str2mat( ...
            '% Reconstruct approximation and details', ...
            '% at level 1, from coefficients.', ...
            '%', ...
            '% step 1 : extract coefficients', ...
            '% decomposition structure [c,s].', ...
            '%', ...
            '% step 2 : reconstruct.' ...
                );
wshowdrv('disp',figNumber,comment);

% Reconstruct approximation and details
% at level 1, from coefficients.
% 
% step 1 : extract coefficients
% decomposition structure [c,s].
%
% step 2 : reconstruct.

if wshowdrv('pause',figNumber,wait_mode)
	if ishandle(pop), set(pop,'Enable','on'); end
	return;
end;

comment = str2mat( ...
            '    siz = s(size(s,1),:);', ...
            '    ca1 = appcoef2(c,s,''db1'',1);', ...
            '    ch1 = detcoef2(''h'',c,s,1);', ...
            '    cv1 = detcoef2(''v'',c,s,1);', ...
            '    cd1 = detcoef2(''d'',c,s,1);', ...
            '    a1  = upcoef2(''a'',ca1,''db1'',1,siz);', ...
            '    hd1 = upcoef2(''h'',ch1,''db1'',1,siz);', ...
            '    vd1 = upcoef2(''v'',cv1,''db1'',1,siz);', ...
            '    dd1 = upcoef2(''d'',cd1,''db1'',1,siz);' ...
                );
wshowdrv('disp',figNumber,comment);

        siz  = s(size(s,1),:);
        
        ca1  = appcoef2(c,s,'db1',1);
        a1   = upcoef2('a',ca1,'db1',1,siz);
        clear ca1 

        ch1 = detcoef2('h',c,s,1);
        hd1 = upcoef2('h',ch1,'db1',1,siz);
        clear ch1
 
        cv1 = detcoef2('v',c,s,1);
        vd1 = upcoef2('v',cv1,'db1',1,siz);
        clear cv1 

        cd1 = detcoef2('d',c,s,1);
        dd1 = upcoef2('d',cd1,'db1',1,siz);
        clear cd1 

figure(active_fig)
ax = subplot(3,4,5); image(wcodemat(a1,nbcol)); axis('square');
title('a1');
set(ax,'Xtick',[],'Xticklabel',[],...
       'Ytick',[],'Yticklabel',[]);
clear a1

figure(active_fig)
ax = subplot(3,4,6); image(wcodemat(hd1,nbcol)); axis('square');
title('h1');
set(ax,'Xtick',[],'Xticklabel',[],...
       'Ytick',[],'Yticklabel',[]);
clear hd1

figure(active_fig)
ax = subplot(3,4,7); image(wcodemat(vd1,nbcol)); axis('square');
title('v1');
set(ax,'Xtick',[],'Xticklabel',[],...
       'Ytick',[],'Yticklabel',[]);
clear vd1

figure(active_fig)
ax = subplot(3,4,8); image(wcodemat(dd1,nbcol)); axis('square');
title('d1');
set(ax,'Xtick',[],'Xticklabel',[],...
       'Ytick',[],'Yticklabel',[]);
clear dd1

if wshowdrv('pause',figNumber,wait_mode)
	if ishandle(pop), set(pop,'Enable','on'); end
	return;
end;

comment = str2mat( ...
            '% Reconstruct X from the wavelet', ...
            '% decomposition structure [c,s].', ...
            ' ', ...
            '        a0 = waverec2(c,s,''db1'');' ...
                );
wshowdrv('disp',figNumber,comment);

% Reconstruct X from the wavelet
% decomposition structure [c,s].
        a0 = waverec2(c,s,'db1');

figure(active_fig)
ax = subplot(3,4,3); image(wcodemat(a0,nbcol)); axis('square');
title('Reconstructed image a0.');
set(ax,'Xtick',[],'Xticklabel',[],...
       'Ytick',[],'Yticklabel',[]);

set(active_fig,'DefaultAxesXTicklabel','remove',...
               'DefaultAxesYTicklabel','remove');

if figNumber==0
        wshowdrv('pause',figNumber,wait_mode);
	delete(active_fig);
else
	if ishandle(pop), set(pop,'Enable','on'); end
end
