function dcmddw1d(varargin)
%DCMDDW1D Demonstrates discrete 1-D wavelet tools in the Wavelet Toolbox.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-Mar-96.
%   Last Revision: 27-Jun-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.12 $

% Check arguments.
%=================
switch nargin
  case 0 , figNumber = 0; wait_mode = 1;
  case 2 ,   
    if isequal(varargin{1},'noGUI')
        figNumber = 0;
        wait_mode = varargin{2};
    else
        figNumber = varargin{1};
        wait_mode = 1;
    end
end

if wshowdrv('init',figNumber)
    echo off
    clc;
    titre = 'Orthogonal Wavelets 1-D';
    if figNumber==0
	active_fig = wdfigutl('create',titre);
    else
        set(figNumber,'Name',titre);
        wshowdrv('setactfig',figNumber,figNumber);
        democmdm('startshow',figNumber,'dw1d');
        return;
    end
end
if figNumber , active_fig = wshowdrv('getactfig',figNumber); end

comment = str2mat( ...
          '% Load original 1D signal.', ...
          ' ', ...
          '        load leleccum; s = leleccum(1:3920);', ...
          '        ls = length(s);' ...
          );
wshowdrv('disp',figNumber,comment);

% Load original 1D signal.
        load leleccum; s = leleccum(1:3920);
        ls = length(s);
                
clear leleccum
figure(active_fig)
subplot(211); 
plot(1:ls,s,'r');
title('Original signal s.');

if wshowdrv('pause',figNumber,wait_mode), return; end;

comment = str2mat( ...
          '% Perform one step decomposition', ...
          '% of s using db1.', ...
          ' ', ...
          '        [ca1,cd1] = dwt(s,''db1'');' ...
          );
wshowdrv('disp',figNumber,comment);

% Perform one step decomposition
% of s using db1.
        [ca1,cd1] = dwt(s,'db1');

figure(active_fig)
subplot(223);
plot(1:length(ca1),ca1);
title('Approx. coef. : ca1');
subplot(224);
plot(1:length(cd1),cd1);
title('Detail coef. : cd1');

if wshowdrv('pause',figNumber,wait_mode), return; end;

comment = str2mat( ...
          '% Perform one step reconstruction of', ...
          '% ca1 and cd1.', ...
          ' ', ...
          '        a1 = upcoef(''a'',ca1,''db1'',1,ls);' ,...
          '        d1 = upcoef(''d'',cd1,''db1'',1,ls);' ...
          );
wshowdrv('disp',figNumber,comment);

% Perform one step reconstruction of
% ca1 and cd1.
        a1 = upcoef('a',ca1,'db1',1,ls);
        d1 = upcoef('d',cd1,'db1',1,ls);

% Reset axes.
%------------
delete(findobj(active_fig,'type','axes'));

figure(active_fig)
h1 = subplot(311); plot(1:ls,s,'r');
title('Original signal s.'); 
h2 = subplot(312); plot(1:ls,a1);
title('Approximation : a1.');
h3 = subplot(313); plot(1:ls,d1);
title('Detail : d1.');
set([h1,h2],'Xtick',[],'Xticklabel',[]);

if wshowdrv('pause',figNumber,wait_mode), return; end;

comment = str2mat( ...
          '% Now plot a1 + d1.' ...
          );
wshowdrv('disp',figNumber,comment);

% Reset axes.
%------------
delete(findobj(active_fig,'type','axes'));

% Now plot a1 + d1.
figure(active_fig)
h1 = subplot(311); plot(1:ls,s,'r');
title('Original signal s.'); 
h2 = subplot(312); plot(1:ls,a1 + d1);
title('Approximation + detail : a1  + d1.');
set(h1,'Xtick',[],'Xticklabel',[]);

if wshowdrv('pause',figNumber,wait_mode), return; end;

comment = str2mat( ...
          '% Invert directly decomposition of s', ...
          '% using coefficients.', ...
          ' ', ...
          '        a0 = idwt(ca1,cd1,''db1'',ls);' ...
          );
wshowdrv('disp',figNumber,comment);

% Invert directly decomposition of s
% using coefficients.
        a0 = idwt(ca1,cd1,'db1',ls);

figure(active_fig)
h3 = subplot(313); plot(1:ls,a0);
title('Reconstructed signal : a0.');
set(h2,'Xtick',[],'Xticklabel',[]);

if wshowdrv('pause',figNumber,wait_mode), return; end;

comment = str2mat( ...
          '% Perform decomposition at level 3', ...
          '% of s using db1.', ...
          ' ', ...
          '        [c,l] = wavedec(s,3,''db1'');' ...
          );
wshowdrv('disp',figNumber,comment);

% Perform decomposition at level 3
% of s using db1.
        [c,l] = wavedec(s,3,'db1');

% Reset axes.
%------------
delete(findobj(active_fig,'type','axes'));

figure(active_fig)
h1 = subplot(511); plot(1:ls,s,'r');
title('Original signal s.');

if wshowdrv('pause',figNumber,wait_mode), return; end;

comment = str2mat( ...
          '% Extract approximation coefficients', ...
          '% at level 3, from wavelet decomposition', ...
          '% structure [c,l].', ...
          ' ', ...
          '        ca3 = appcoef(c,l,''db1'',3);' ...
          );
wshowdrv('disp',figNumber,comment);

% Extract approximation coefficients
% at level 3, from wavelet decomposition
% structure [c,l].
        ca3 = appcoef(c,l,'db1',3);

figure(active_fig)
set(h1,'Xtick',[],'Xticklabel',[]);
h2 = subplot(5,8,9); plot(1:length(ca3),ca3);
subplot(511); title('Original signal s and ca3.');

if wshowdrv('pause',figNumber,wait_mode), return; end;

comment = str2mat( ...
          '% Extract detail coefficients at levels', ...
          '% 1, 2 and 3, from wavelet decomposition', ...
          '% structure [c,l].', ...
          ' ', ...
          '        cd3 = detcoef(c,l,3);', ...
          '        cd2 = detcoef(c,l,2);', ...
          '        cd1 = detcoef(c,l,1);' ...
          );
wshowdrv('disp',figNumber,comment);

% Extract detail coefficients at levels
% 1, 2 and 3, from wavelet decomposition
% structure [c,l].
        cd3 = detcoef(c,l,3);
        cd2 = detcoef(c,l,2);
        cd1 = detcoef(c,l,1);

figure(active_fig)
subplot(511); title('Original signal s , ca3 and cd3.');
% subplot(511); title('Original signal s and coefficients.');
set(h2,'Xtick',[],'Xticklabel',[]);
h3 = subplot(5,8,17); plot(1:length(cd3),cd3);
pause(2)
subplot(511); title('Original signal s , ca3, cd3 and cd2.');
set(h3,'Xtick',[],'Xticklabel',[]);
h4 = subplot(5,4,13); plot(1:length(cd2),cd2);
pause(2);
subplot(511); title('Original signal s , ca3, cd3, cd2 and cd1.');
set(h4,'Xtick',[],'Xticklabel',[]);
h5 = subplot(5,2,9); plot(1:length(cd1),cd1);

if wshowdrv('pause',figNumber,wait_mode), return; end;

comment = str2mat( ...
          '% Reconstruct approximation at level 3,', ...
          '% from the wavelet decomposition', ...
	  '% structure [c,l].', ...
          ' ', ...
          '        a3 = wrcoef(''a'',c,l,''db1'',3);' ...
          );
wshowdrv('disp',figNumber,comment);

% Reconstruct approximation at level 3,
% from the wavelet decomposition
% structure [c,l].
        a3 = wrcoef('a',c,l,'db1',3);

% Reset axes.
%------------
delete(findobj(active_fig,'type','axes'));

figure(active_fig)
h1 = subplot(511); plot(s,'r');
title('Original signal s and app. level 3.');
h2 = subplot(512); plot(1:ls,a3);
set(h1,'Xtick',[],'Xticklabel',[]);

if wshowdrv('pause',figNumber,wait_mode), return; end;

comment = str2mat( ...
          '% Reconstruct detail coefficients at', ...
          '% levels 1, 2 and 3, from the wavelet', ...
          '% decomposition structure [c,l].', ...
          ' ', ...
          '        d3 = wrcoef(''d'',c,l,''db1'',3);', ...
          '        d2 = wrcoef(''d'',c,l,''db1'',2);', ...
          '        d1 = wrcoef(''d'',c,l,''db1'',1);' ...
          );
wshowdrv('disp',figNumber,comment);

% Reconstruct detail coefficients at
% levels 1, 2 and 3, from the wavelet
% decomposition structure [c,l].
            d3 = wrcoef('d',c,l,'db1',3);
            d2 = wrcoef('d',c,l,'db1',2);
	    d1 = wrcoef('d',c,l,'db1',1);

figure(active_fig)
subplot(511); title('Original signal and a3 d3 d2 d1.');
h3 = subplot(513); plot(1:ls,d3);
h4 = subplot(514); plot(1:ls,d2);
h5 = subplot(515); plot(1:ls,d1);
set([h2,h3,h4],'Xtick',[],'Xticklabel',[]);

if wshowdrv('pause',figNumber,wait_mode), return; end;

comment = str2mat( ...
          '% Reconstruct s from the wavelet', ...
          '% decomposition structure [c,l].', ...
          ' ', ...
          '        a0 = waverec(c,l,''db1'');' ...
          );
wshowdrv('disp',figNumber,comment);

% Reconstruct s from the wavelet
% decomposition structure [c,l].
        a0 = waverec(c,l,'db1');

% Reset axes.
%------------
delete(findobj(active_fig,'type','axes'));

figure(active_fig)
subplot(211); plot(s,'r');
title('Original signal s.');
subplot(212); plot(1:ls,a0);
title('Reconstructed signal a0.');

if figNumber==0
        wshowdrv('pause',figNumber,wait_mode);
        delete(active_fig);
end
