function dcmdcw1d(varargin)
%DCMDCW1D Demonstrates continuous 1-D wavelet tools in the Wavelet Toolbox.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-Mar-96.
%   Last Revision: 26-Jun-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
% $Revision: 1.12 $

% Check arguments.
%=================
switch nargin
  case 0 , figNumber = 0; wait_mode = 1;
  case 2 ,   
    if isequal(varargin{1},'noGUI')
        figNumber = 0;
        wait_mode = varargin{2};
    else
        figNumber = varargin{1};
        wait_mode = 1;
    end
end

if wshowdrv('init',figNumber)
    echo off
    clc;
    titre ='Continuous Wavelet Transform 1-D';
    if figNumber==0
	active_fig = wdfigutl('create',titre);
    else
        set(figNumber,'Name',titre);
        wshowdrv('setactfig',figNumber,figNumber);
        democmdm('startshow',figNumber,'cw1d');
        return;
    end
end
if figNumber , active_fig = wshowdrv('getactfig',figNumber); end

% Demo 1.
%--------
comment = str2mat( ...
            '% Load original fractal signal.', ...
            ' ', ...
            '        load vonkoch', ...
            '        vonkoch = vonkoch(1:510);', ...
            '        lv = length(vonkoch);' ...
                );
wshowdrv('disp',figNumber,comment); 

% Load original fractal signal.
        load vonkoch
        vonkoch = vonkoch(1:510);
        lv = length(vonkoch);

figure(active_fig)
h1 = subplot(311);
plot(vonkoch,'r');title('Analyzed signal.');
set(gca,'Xlim',[0 510])

if wshowdrv('pause',figNumber,wait_mode), return; end;

comment = str2mat( ...
            '% This example aims to demonstrate the difference between', ...
            '% discrete and continuous wavelet transforms.', ...
            '% Perform discrete wavelet transform at level 5 by sym2.', ...
            '% Levels 1 to 5 correspond to scales 2, 4, 8, 16 and 32.', ...
            ' ', ...
            '        [c,l] = wavedec(vonkoch,5,''sym2'');' ...
                );
wshowdrv('disp',figNumber,comment); 

% This example aims to demonstrate the difference between
% discrete and continuous wavelet transforms.

% Perform discrete wavelet transform at level 5 by sym2. 
% Levels 1 to 5 correspond to scales 2, 4, 8, 16 and 32.
[c,l] = wavedec(vonkoch,5,'sym2');

if wshowdrv('pause',figNumber,wait_mode), return; end;

comment = str2mat( ...
            '% Expand discrete wavelet coefficients for plot.', ...
            '% Levels 1 to 5 correspond to scales 2, 4, 8, 16 and 32.' ...
                );
wshowdrv('disp',figNumber,comment);

% Expand discrete wavelet coefficients for plot.
% Levels 1 to 5 correspond to scales 2, 4, 8, 16 and 32.
cfd = zeros(5,lv);
for k = 1:5
    d = detcoef(c,l,k);
    d = d(:)';
    d = d(ones(1,2^k),:);
    cfd(k,:) = wkeep(d(:)',lv);
end
cfd =  cfd(:);
I = find(abs(cfd)<sqrt(eps));
cfd(I) = zeros(size(I));
cfd = reshape(cfd,5,lv);

figure(active_fig)
set(h1,'Xtick',[],'Xticklabel',[]);
h2 = subplot(312);

comment = str2mat( ...
            '% Plot discrete coefficients.', ...
            ' ', ...
            '        colormap(pink(64));', ...
            '        img = image(wcodemat(cfd,64,''row''));' ...
                );
wshowdrv('disp',figNumber,comment);

% Plot discrete coefficients.
%----------------------------
figure(active_fig)
colormap(pink(64));
img = image(wcodemat(cfd,64,'row'));
tics = 1:1:5;
labs = str2mat('1','2','3','4','5');
set(get(img,'parent'), ...
    'YTicklabelMode','manual', ...
    'YTick',tics,              ...
    'YTickLabel',labs,         ...
    'YDir','normal',	       ...
    'Box','On'                 ...
    );
title('Discrete Transform, absolute coefficients.')
ylabel('level')

if wshowdrv('pause',figNumber,wait_mode), return; end;

set(h2,'Xtick',[],'Xticklabel',[]);

comment = str2mat( ...
            '% compute coefficients.', ...
            ' ', ...
            '        coefs = cwt(vonkoch,1:32,''sym2'',''plot'');', ...
            '        colormap(pink(64));' ...
                );
wshowdrv('disp',figNumber,comment);

% compute coefficients.
figure(active_fig)
h3 = subplot(313);
coefs = cwt(vonkoch,1:32,'sym2','plot');
colormap(pink(64))

tt = get(h3,'Yticklabel');
[r,c] = size(tt);
yl = setstr(32*ones(r,c));
for k = 1:3:r , yl(k,:) = tt(k,:); end
set(h3,'Yticklabel',yl);

if wshowdrv('pause',figNumber,wait_mode), return; end;

% Demo 2.
%---------
% Reset axes.
delete(findobj(active_fig,'type','axes'));

comment = str2mat( ...
            '% Another example.', ...
            ' ', ...
            '        wname   = ''db1'';', ...
            '        scales  = [1:32];', ...
            '        load freqbrk' ...
                );
wshowdrv('disp',figNumber,comment);

wname  = 'db1';
scales = [1:32];
load freqbrk
signal = freqbrk;
clear freqbrk;
map = cool(128);
lv  = length(signal);
figure(active_fig)
h1 = subplot(311);
plot(signal,'r');title('Analyzed signal.');
set(gca,'Xlim',[0 lv])

[c,l]   = wavedec(signal,5,wname);
cfd = zeros(5,lv);
for k = 1:5
	d = detcoef(c,l,k);
        d = d(:)';
        d = d(ones(1,2^k),:);
        cfd(k,:) = wkeep(d(:)',lv);
end
cfd =  cfd(:);
I = find(abs(cfd)<sqrt(eps));
cfd(I) = zeros(size(I));
cfd    = reshape(cfd,5,lv);

% Plot discrete coefficients.
figure(active_fig)
set(h1,'Xtick',[],'Xticklabel',[]);
h2 = subplot(312);
colormap(map);
img = image(wcodemat(cfd,64,'row'));
tics = 1:1:5;
labs = str2mat('1','2','3','4','5');
set(get(img,'parent'),             ...
        'YTicklabelMode','manual', ...
        'YTick',tics,              ...
	'YDir','normal',	   ...
        'YTickLabel',labs,         ...
        'Box','On'                 ...
        );
title('Discrete Transform, absolute coefficients.')
ylabel('level')

% set next plot parameters.
figure(active_fig)
set(h2,'Xtick',[],'Xticklabel',[]);
h3 = subplot(313);
coefs = cwt(signal,scales,wname,'plot');

tt = get(h3,'Yticklabel');
[r,c] = size(tt);
yl = setstr(32*ones(r,c));
for k = 1:3:r , yl(k,:) = tt(k,:); end
set(h3,'Yticklabel',yl);
colormap(map);

if figNumber==0
    wshowdrv('pause',figNumber,wait_mode);
    delete(active_fig);
end
