function dcmdcomp(varargin)
%DCMDCOMP Demonstrates compression tools in the Wavelet Toolbox.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-Mar-96.
%   Last Revision: 27-Jun-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
% $Revision: 1.12 $

% Check arguments.
%=================
switch nargin
  case 0 , figNumber = 0; wait_mode = 1;
  case 2 ,   
    if isequal(varargin{1},'noGUI')
        figNumber = 0;
        wait_mode = varargin{2};
    else
        figNumber = varargin{1};
        wait_mode = 1;
    end
end

if wshowdrv('init',figNumber)
    echo off
    clc;
    titre ='Compression 1-D';
    if figNumber==0
	active_fig = wdfigutl('create',titre);
    else
        set(figNumber,'Name',titre);
        wshowdrv('setactfig',figNumber,figNumber);
        democmdm('startshow',figNumber,'comp');
        return;
    end
end
if figNumber , active_fig = wshowdrv('getactfig',figNumber); end

comment = str2mat( ...
                '% Load electrical signal and select a part.', ...
                ' ', ...
                '        load leleccum; indx = 2600:3100;', ...
                '        x = leleccum(indx);' ...
                );
wshowdrv('disp',figNumber,comment);

% Load electrical signal and select a part.
        load leleccum; indx = 2600:3100; 
        x = leleccum(indx);

% Plot Original signal.
figure(active_fig)
h1 = subplot(211);
plot(indx,x,'r'), title('Original signal')

if wshowdrv('pause',figNumber,wait_mode), return; end;

comment = str2mat( ...
                '% Use wdencmp for signal compression.', ...
                ' ', ...
                '        % compress using a fixed threshold', ...
                '        % and compute 2-norm recovery.', ...
                '        thr = 35;',...
                '        [xd,cxd,lxd,perf0,perfl2] = wdencmp(''gbl'',x,''db3'',3,thr,''h'',1);'...
                 );
wshowdrv('disp',figNumber,comment); 

% Use wdencmp for signal compression.

        % compress using a fixed threshold and compute 2-norm recovery.
        thr = 35;
        [xd,cxd,lxd,perf0,perfl2] = wdencmp('gbl',x,'db3',3,thr,'h',1);

% Plot Compressed signal.
figure(active_fig)
set(h1,'Xtick',[],'XtickLabel',[]);
subplot(212);
plot(indx,xd), title('Compressed signal')
xlabel(['2-norm rec.: ',num2str(perfl2,'%5.2f'),...
        ' %  - nul cfs: ',num2str(perf0,'%5.2f'), ' %'])

if wshowdrv('pause',figNumber,wait_mode), return; end;

% Reset axes.
%------------
delete(findobj(active_fig,'type','axes'));

if figNumber
   subr = 1; subc = 2;
else
   subr = 2; subc = 1;
end


if figNumber , fig = figNumber; else , fig = active_fig; end
set(fig,'Name','Compression 2-D');

comment = str2mat( ...
                '% load original image.', ...
                ' ', ...
                '        load woman; x = X(100:200,100:200);' ...
                );
wshowdrv('disp',figNumber,comment); 

% load original image.
        load woman; x = X(100:200,100:200);


% Plot Original Image.
figure(active_fig)
subplot(subr,subc,1);
nbc = size(map,1);
colormap(pink(nbc));
image(wcodemat(x,nbc)), title('Original image')
axis('square');

if wshowdrv('pause',figNumber,wait_mode), return; end;


comment = str2mat( ...
                '% Use wdencmp for image compression.', ...
                '    % wavelet decomposition of x.', ...
                '        n = 5; w = ''sym2'';', ... 
                '        [c,l] = wavedec2(x,n,w);', ...
                '    % wavelet coefficients thresholding', ...
                '    % and computation of  2-norm recovery.', ...
                '        thr = 20;', ...
                '        [xd,cxd,lxd,perf0,perfl2] = wdencmp(''gbl'',c,l,w,n,thr,''h'',1);' ...
                  );
wshowdrv('disp',figNumber,comment);

% Use wdencmp for image compression.

        % wavelet decomposition of x.
        n = 5; w = 'sym2'; 
        [c,l] = wavedec2(x,n,w);

        % wavelet coefficients thresholding.
        thr = 20;
        [xd,cxd,lxd,perf0,perfl2] = wdencmp('gbl',c,l,w,n,thr,'h',1);

% Plot Compressed Image.
figure(active_fig)
subplot(subr,subc,2);
image(wcodemat(xd,nbc))
title(['Compressed Image. Threshold = ',num2str(thr)])
% xlabel(['2-norm rec.: ',num2str(perfl2,'%5.2f'),...
%        ' %  - nul cfs : ',num2str(perf0,'%5.2f'), ' %'])
strxlab = strvcat(['2-norm rec.: ',num2str(perfl2,'%5.2f') ' %'],...
			['nul cfs : ',num2str(perf0,'%5.2f'), ' %']);
xlabel(strxlab);
axis('square');

if wshowdrv('pause',figNumber,wait_mode), return; end;

comment = str2mat( ...
                '% In addition the first option allows level and orientation', ...
                '% dependent thresholds. In this case the approximation is kept.', ...
                '% The level dependent thresholds in the three orientations', ...
                '% horizontal, diagonal and vertical are as follow.', ...
                '        thr_h = [17 18];        % horizontal thresholds.', ...
                '        thr_d = [19 20];        % diagonal thresholds.', ...
                '        thr_v = [21 22];        % vertical thresholds.', ...
                '        thr = [thr_h ; thr_d ; thr_v]', ...
                '        [xd,cxd,lxd,perf0,perfl2] = wdencmp(''lvd'',x,''sym8'',2,thr,''h'');' ...
                  );
wshowdrv('disp',figNumber,comment); 

% In addition the first option allows level and orientation
% dependent thresholds. In this case the approximation is kept.
% The level dependent thresholds in the three orientations
% horizontal, diagonal and vertical are as follow.

        thr_h = [17 18];        % horizontal thresholds.
        thr_d = [19 20];        % diagonal thresholds.
        thr_v = [21 22];        % vertical thresholds.

        thr = [thr_h ; thr_d ; thr_v];        
        [xd,cxd,lxd,perf0,perfl2] = wdencmp('lvd',x,'sym8',2,thr,'h');

% Plot Compressed Image.
figure(active_fig)
subplot(subr,subc,2);
image(wcodemat(xd,nbc))
title(['Comp. Ima. Thr=[17 18;19 20;21 22]'])
% xlabel(['2-norm rec.: ',num2str(perfl2,'%5.2f'),...
%         ' %  - nul cfs : ',num2str(perf0,'%5.2f'), ' %'])

strxlab = strvcat(['2-norm rec.: ',num2str(perfl2,'%5.2f') ' %'],...
			['nul cfs : ',num2str(perf0,'%5.2f'), ' %']);
xlabel(strxlab);

axis('square');

if figNumber==0
        wshowdrv('pause',figNumber,wait_mode);
        delete(active_fig);
end
