function dcmdcasc(varargin)
%DCMDCASC Demonstrates cascade algorithm in the Wavelet Toolbox.

%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 12-Mar-96.
%   Last Revision: 27-Jun-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
% $Revision: 1.10 $

% Check arguments.
%=================
switch nargin
  case 0 , figNumber = 0; wait_mode = 1;
  case 2 ,   
    if isequal(varargin{1},'noGUI')
        figNumber = 0;
        wait_mode = varargin{2};
    else
        figNumber = varargin{1};
        wait_mode = 1;
    end
end

if wshowdrv('init',figNumber)
    echo off
    clc;
    titre = 'Cascade algorithm';
    if figNumber==0
        active_fig = wdfigutl('create',titre);
    else
        set(figNumber,'Name',titre);
        wshowdrv('setactfig',figNumber,figNumber);
        pop = democmdm('startshow',figNumber,'casc');
        if ishandle(pop) , set(pop,'enable','on'); end
        return
    end
end
if figNumber , active_fig = wshowdrv('getactfig',figNumber); end

%-------------------------------------
% To display all type of wavelet,
% uncomment the commented lines below.
%-------------------------------------
nophi = 0;
wavfunCallstr = ['           [phi,'];
if figNumber
   pop = democmdm('startshow',figNumber,'casc');
   v = get(pop,'value');
   s = get(pop,'string');
   wav = deblankl(s(v,:));
else
   pop = NaN;
   wav = 'sym4';
end
wavfunCallstr = [wavfunCallstr 'psi,xval] = wavefun(''' wav ''',i);'];

beg_title = ['Approximation of the wavelet ' wav '. Iteration : '];
comment = str2mat( ...
           '% compute approximations of the wavelet function', ...
           '% using the cascade algorithm.', ...
           '       iter = 10;', ...
           '       for i = 1:iter', ...
           wavfunCallstr, ...
           '           plot(xval,psi);', ...
           '           hold on', ...
           '           drawnow', ...
           '       end' ...
           );
wshowdrv('disp',figNumber,comment) 
if ishandle(pop) , set(pop,'enable','off'); end

% Set number of iterations and wavelet name.
iter = 10;

% compute approximations of the wavelet function
% using the cascade algorithm for orthogonal or
% biorthogonal wavelets, and direct computation
% for meyer, morlet or mexihat wavelets
%----------------------------------------------- 
for i = 1:iter
    if nophi
       [psi,xval] = wavefun(wav,i);
    else
       [phi,psi,xval] = wavefun(wav,i);
	end
	figure(active_fig)
    plot(xval,psi);
    hold on
	title( [beg_title int2str(i)]);
	if wshowdrv('stop',figNumber), return; end;
    if      i==1 ,           pause(2)
    elseif  (1<i) & (i<=4) , pause(1)
    else ,                   pause(0.5)
    end
    drawnow
end

figure(active_fig)
title(['Approximations of the wavelet ',wav,' for 1 to ', ...
      int2str(iter),' iterations']);

linw = 2;
h = plot(xval,psi,'r','linewidth',linw);
drawnow
hold off

if wshowdrv('pause',figNumber,wait_mode), return; end;

figure(active_fig)
h = plot(xval,psi,'r','linewidth',linw);
title(['Approximation of the wavelet ',wav,...
       ' after ' int2str(iter),' iterations.']);
drawnow

if figNumber==0
    wshowdrv('pause',figNumber,wait_mode);
    delete(active_fig);
else
    if ishandle(pop) , set(pop,'enable','on'); end
end
