function x = merge(t,node,tnd)
%MERGE Merge (recompose) the data of a node.
%   X = MERGE(T,N,TNDATA) recomposes the data X 
%   associated to the node N of the data tree T,
%   using the data associated to the children of N.
%
%   TNDATA is a cell array (ORDER x 1) or (1 x ORDER)
%   such that TNDATA{k} contains the data associated to
%   the k-th child of N.
%
%   The method uses IDWT (respectively IDWT2) for
%   one-dimensional (respectively two-dimensional) data.
%
%   This method overloads the DTREE method.
 
%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 09-Oct-1998.
%   Last Revision: 27-Oct-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.3 $  $Date: 2001/03/30 16:41:14 $ 

order = get(t,'order');
mode  = t.dwtMode;
Lo_R = t.waveInfo.Lo_R;
Hi_R = t.waveInfo.Hi_R;
s = read(t,'sizes',node);
switch order
  case 2 , x = idwt(tnd{1},tnd{2},Lo_R,Hi_R,max(s),'mode',mode,'shift',0);
  case 4
    x = idwt2(tnd{1},tnd{2},tnd{3},tnd{4},...
              Lo_R,Hi_R,s,'mode',mode,'shift',[0 0]);
end
