function x = merge(t,node,tnd)
%MERGE Merge (recompose) the data of a node.
%   X = MERGE(T,N,TNDATA) recomposes the data X 
%   associated to the node N of the data tree T,
%   using the data associated to the children of N.
%
%   TNDATA is a cell array (ORDER x 1) or (1 x ORDER)
%   such that TNDATA{k} contains the data associated to
%   the k-th child of N.
%
%   The method uses IDWT.
 
%   M. Misiti, Y. Misiti, G. Oppenheim, J.M. Poggi 09-Sep-1999.
%   Last Revision: 27-Oct-1999.
%   Copyright 1995-2001 The MathWorks, Inc.
%   $Revision: 1.3 $  $Date: 2001/03/30 16:37:32 $ 

order = get(t,'order');
s = read(t,'sizes',node);
Lo_R = t.waveInfo.Lo_R;
Hi_R = t.waveInfo.Hi_R;
mode  = t.dwtMode;
x = 0.5*(idwt(tnd{1},tnd{2},Lo_R,Hi_R,max(s),'mode',mode,'shift',0)+ ...
         idwt(tnd{4},tnd{3},Lo_R,Hi_R,max(s),'mode',mode,'shift',1));
